% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rimi.R
\name{rimi}
\alias{rimi}
\title{Relative Importance of Main and Interaction Effects}
\source{
\url{https://github.com/dromarnrc/Modified-Generalized-Weights/blob/main/MGW}
}
\usage{
rimi(data)
}
\arguments{
\item{data}{input data set}
}
\value{
A table and figure with relative importance of inputs and their two way interaction
}
\description{
A new method to compute relative importance of main and interaction effects
of inputs in Artificial Neural Networks. The method was published in a paper on 20 June 2022
at \url{https://link.springer.com/article/10.1134/S1064229322080051} under the title of
"Modeling Main and Interactional Effects of Some Physiochemical Properties of Egyptian Soils
on Cation Exchange Capacity Via Artificial Neural Networks". The relative importance is computed
based on R square, and recomputed based on 100 percent for comparison. Also, sum of the modified
generalized weights is computed.
}
\details{
The data must be two or more numeric inputs and one output, the output must be in the last column,
columns must have headers or names. The used neural network is Multilayer perceptron with back propagation
algorithm. The number of neurons in hidden layer is 1.6 times the number of inputs. If you want to change
these setting, you can use the code on github.
}
\examples{
x1<-rnorm(100,2,0.5)
x2<-rnorm(100,3,2)
y<-rnorm(100,6,3)
df<-data.frame(x1,x2,y)
rimi(df)
}
\references{
Ibrahim, O.M., El-Gamal, E.H., Darwish, K.M. Modeling Main and Interactional Effects
of Some Physiochemical Properties of Egyptian Soils on Cation Exchange Capacity Via Artificial
Neural Networks. Eurasian Soil Sc. (2022). https://doi.org/10.1134/S1064229322080051
}
