% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_correlation_matrix.R
\name{struc_cor_mat}
\alias{struc_cor_mat}
\title{Simulate a structured correlation matrix with reduced rank}
\usage{
struc_cor_mat(
  n = 5,
  base.cor = 0.5,
  range = NULL,
  rank = 3,
  skew = 0,
  base.mat = NULL,
  pos.def = FALSE,
  small.positive = NULL
)
}
\arguments{
\item{n}{A scalar defining the dimensions of the correlation matrix.}

\item{base.cor}{A scalar defining the baseline correlation. \cr
\strong{Note:} \code{-1 < base.cor < 1}.}

\item{range}{A scalar defining the range of correlations around the baseline. By default,
\code{range = 1 - base.cor} which ensures the matrix is positive semi-definite with defined rank.
\strong{Note:} \code{base.cor + range <= 1}.}

\item{rank}{A scalar defining the rank of the correlation matrix.}

\item{skew}{A scalar defining the skewness imposed on the correlations.
\strong{Note:} \code{-1 < skew < 1}.}

\item{base.mat}{An optional \code{n x n} base correlation matrix.
When supplied, \code{base.cor} and \code{skew} are ignored and noise is simulated based on \code{rank}.}

\item{pos.def}{When \code{TRUE} (default is \code{FALSE}), the function \code{bend} of the R package
\href{https://cran.r-project.org/package=mbend}{`mbend`} is used to
bend a non-positive (semi)-definite matrix to be positive (semi)-definite.}

\item{small.positive}{Argument passed to \code{bend} when \code{pos.def = TRUE} (default is 1e-8).
Eigenvalues smaller than \code{small.positive} are replaced by this. \cr
\strong{Note:} \code{0 < small.positive < 0.1}.}
}
\value{
A symmetric \code{n x n} correlation matrix with defined rank.
  When \code{pos.def = TRUE}, the correlation matrix is guaranteed to be positive (semi)-definite.
}
\description{
Creates a symmetric \code{n x n} correlation matrix with user-defined structure and rank.
}
\examples{
# Simulate and visualise a correlation matrix with 10 columns and rows, rank equal to 4 and
# negatively skewed correlations.
cor_mat <- struc_cor_mat(
  n = 10,
  base.cor = 0.3,
  range = 0.7,
  rank = 4,
  skew = -0.5
)

plot_matrix(
  mat = cor_mat,
  order = TRUE
)

}
