% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsmm.R
\name{lsmm}
\alias{lsmm}
\title{lsmm : Estimation of location scale mixed model}
\usage{
lsmm(
  formFixed,
  formRandom,
  formGroup,
  timeVar,
  data.long,
  variability_hetero = TRUE,
  formFixedVar,
  formRandomVar,
  correlated_re = FALSE,
  S1 = 1000,
  S2 = 5000,
  nproc = 1,
  clustertype = "SOCK",
  maxiter = 100,
  print.info = FALSE,
  file = NULL,
  epsa = 0.001,
  epsb = 0.001,
  epsd = 0.001,
  binit = NULL
)
}
\arguments{
\item{formFixed}{A formula for the fixed effects of the longitudinal submodel}

\item{formRandom}{A formula for the random effects of the longitudinal submodel}

\item{formGroup}{A formula which indicates the group variable}

\item{timeVar}{The name of the column of time in data.long. This variable must appears in data.long}

\item{data.long}{A dataframe with the longitudinal data}

\item{variability_hetero}{A logical to indicate if we suppose a subject_specific variability}

\item{formFixedVar}{A formula for the fixed effects of the variance predictor}

\item{formRandomVar}{A formula for the random effects of the variance predictor}

\item{correlated_re}{A logical to indicate if the random effects of the marker and the variance predictors are correlated (By default there are supposed to be independent)}

\item{S1}{An integer : the number of QMC draws for the first step}

\item{S2}{An integer : the number of QMC draws for the second step}

\item{nproc}{An integer : the number of processors for parallel computing}

\item{clustertype}{one of the supported types from \code{makeCluster} function}

\item{maxiter}{optional maximum number of iterations for the marqLevAlg iterative algorithm.}

\item{print.info}{logical indicating if the outputs of each iteration should be written}

\item{file}{optional character giving the name of the file where the outputs of each iteration should be written (if print.info=TRUE)}

\item{epsa}{optional threshold for the convergence criterion based on the parameter stability.}

\item{epsb}{optional threshold for the convergence criterion based on the objective function stability.}

\item{epsd}{optional threshold for the relative distance to maximum. This criterion has the nice interpretation of estimating the ratio of the approximation error over the statistical error, thus it can be used for stopping the iterative process whatever the problem.}

\item{binit}{optional initials parameters.}
}
\value{
A FlexVarJoint object which contains the following elements :
\describe{
\item{\code{result}}{A marqLevAlg object with the results of the estimation.}
\item{\code{table.res}}{The table of results : Estimation and SE}
\item{\code{time.compute}}{Computation time}
\item{\code{control}}{A list of control elements}

}
}
\description{
This function fits complex mixed effects model with a time and covariate dependent variance.
We suppose that the variance of the residual error is time-dependent and subject-specific.
Parameters are estimated simultaneously through a maximum likelihood method, using a Marquardt-Levenberg algorithm.
}
\details{
The model is defined by :
#' \eqn{\quad\left\{\begin{array}{ll}
Y_{ij} = Y_{i}(t_{ij}) = \widetilde{Y}_i(t_{ij}) + \epsilon_{ij} = X_{ij}^{\top} \beta+Z_{ij}^{\top} b_{i}+\epsilon_{ij}, \\
\epsilon_{ij}(t_{ij}) \sim \mathcal{N}(0,\sigma_i^2(t_{ij})) \hspace{3mm} \text{with} \hspace{3mm} \log(\sigma_i(t_{ij}))  = O_{ij}^{\top} \mu+M_{ij}^{\top} \tau_{i}
\end{array}
\right.}
\subsection{with \eqn{X_{ij}}, \eqn{O_{ij}}, \eqn{Z_{ij}} and \eqn{M_{ij}} four vectors of explanatory variables for subject \eqn{i} at visit \eqn{j},
respectively associated with the fixed-effect vectors \eqn{\beta} and \eqn{\mu}, and the subject-specific random-effect vector \eqn{b_i} and \eqn{\tau_i}, such as
\eqn{\quad\left(\begin{array}{c}
             b_{i} \\
             \tau_i
             \end{array}\right) \sim N\left(\left(\begin{array}{c}
                                                  0 \\
                                                  0
                                                  \end{array}\right),\left(\begin{array}{cc}
                                                                           \Sigma_{b} & \Sigma_{\tau b} \\
                                                                           \Sigma_{\tau b}' & \Sigma_{\tau}
\end{array}\right)\right)}}{

\eqn{Y_{i}(t_{ij}) = \tilde{Y}_i(t_{ij}) + \epsilon_{ij} = X_{ij}^{\top} \beta+Z_{ij}^{\top} b_{i}+\epsilon_{ij}}

with \eqn{X_{ij}} and \eqn{Z_{ij}} two covariate vectors for subject i at visit j,
respectively associated with the vector of fixed effects \eqn{\beta} and the vector of
subject-specific individual random effects \eqn{b_i}.
The vector \eqn{b_i} is assumed to be normally distributed and a specific-subject random effect on the
variance of the measure error can be added: \eqn{\epsilon_{ij} \sim \mathcal{N}(0,\sigma_i^2)} and

\eqn{\quad\left(\begin{array}{c}
b_{i} \\
\log \sigma_{i}
\end{array}\right) \sim \mathcal{N}\left(\left(\begin{array}{c}
                                               0 \\
                                               \mu_{\sigma}
                                               \end{array}\right),\left(\begin{array}{cc}
                                                                        \Sigma_{b} & 0 \\
                                                                        0 & \tau_{\sigma}^{2}
                                                                        \end{array}\right)\right)}
}
}
\examples{

\donttest{


#fit a joint model with competing risks and subject-specific variability
example <- lsmm(formFixed = y~visit,
formRandom = ~ visit,
formGroup = ~ID,
timeVar = "visit",
data.long = Data_toy,
variability_hetero = TRUE,
formFixedVar =~visit,
formRandomVar =~visit,
correlated_re = TRUE,
S1 = 100,
S2 = 1000,
nproc = 1,
maxiter = 100
)

summary(example)
}

}
