% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{beast.fbd.format}
\alias{beast.fbd.format}
\title{Transforms a tree and fossils into a sampled tree in BEAST-usable format and writes it in Newick format.}
\usage{
beast.fbd.format(
  tree,
  fossils,
  rho = 1,
  sampled_tips = NULL,
  tip_order = "oldest_first",
  ...
)
}
\arguments{
\item{tree}{Complete tree.}

\item{fossils}{fossils dataframe.}

\item{rho}{Sampling probability of extant tips. Default 1, will be disregarded if sampled_tips is not null.}

\item{sampled_tips}{List of tip labels corresponding to sampled extant tips.}

\item{tip_order}{Order of indexes to assign to the tips, either `oldest_first` (by default, first = oldest and last = youngest) or `youngest_first` (reversed).}

\item{...}{Additional parameters will be passed to ape::write.tree}
}
\value{
Output of write.tree.
}
\description{
For each species, removes all the intermediate fossils and leave only the youngest and oldest. The oldest and youngest of each species will be
labelled according to the `tip_order` argument.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils
f = sim.fossils.poisson(rate = 2, tree = t)

# output for BEAST
beast.fbd.format(t, f) # output on the console
\dontrun{
beast.fbd.format(t, f, file="example.tre") # output in file
}
}
