% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.funsurv}
\alias{plot.funsurv}
\title{Plot method for 'funsurv' objects}
\usage{
\method{plot}{funsurv}(x, what = c("beta", "fpc", "basesurv"), ...)
}
\arguments{
\item{x}{A funsurv object}

\item{what}{A character string specifying what to be plotted.
Use \code{what = "beta"} to plot the estimated \eqn{\beta(t)}.
Use \code{what = "fpc"} to plot the functional principal components associated with the the longitudinal measurements.
Use \code{what = "basesurv"} to plot the baseline survival probabilities.}

\item{...}{additional graphical parameters to be passed to methods.}
}
\value{
A ggplot object ...
}
\description{
Plot method for 'funsurv' objects
}
\examples{
data(simDat)
fit <- AR1_FRAILTY(Recur(t_start \%to\% t_stop, id, status) ~ z1,
                   sdat = sdat, fdat = fdat, iter.max = 30)
plot(fit, what = "beta")
plot(fit, what = "fpc")
plot(fit, what = "basesurv")
}
