% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_audit_scales.R
\name{gg_audit_scales}
\alias{gg_audit_scales}
\title{Audit Scales and Axes for Misleading Practices}
\usage{
gg_audit_scales(plot)
}
\arguments{
\item{plot}{A ggplot2 object}
}
\value{
A list of issues, warnings, and suggestions
}
\description{
Checks for truncated axes, inappropriate transformations,
and other scale-related issues that can mislead viewers.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  ylim(15, 35)
gg_audit_scales(p)
}
