% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.functions6.R
\name{gpr}
\alias{gpr}
\title{Gaussian process regression (GPR) model}
\usage{
gpr(
  response,
  input,
  Cov = "pow.ex",
  m = NULL,
  hyper = NULL,
  NewHyper = NULL,
  meanModel = 0,
  mu = NULL,
  gamma = 2,
  nu = 1.5,
  useGradient = T,
  iter.max = 100,
  rel.tol = 8e-10,
  trace = 0,
  nInitCandidates = 1000
)
}
\arguments{
\item{response}{Response data. It should be a matrix, where each column is a
realisation. It can be a vector if there is only one realisation.}

\item{input}{Input covariates. It must be either a matrix, where each column
represents a covariate, or a vector if there is only one covariate.}

\item{Cov}{Covariance function(s) to use. Options are: 'linear', 'pow.ex',
'rat.qu', and 'matern'. Default to 'power.ex'.}

\item{m}{If Subset of Data is to be used, m denotes the subset size and
cannot be larger than the total sample size. Default to NULL.}

\item{hyper}{The hyperparameters. Default to NULL. If not NULL, then it must
be a list with appropriate names.}

\item{NewHyper}{Vector of names of the new hyperparameters of the customized
kernel function. These names must have the format: xxxxxx.x, i.e. '6 digit'
followed by 'a dot' followed by '1 digit'. This is required for both
'hyper' and 'NewHyper'}

\item{meanModel}{Type of mean function. It can be \describe{ \item{0}{Zero
mean function} \item{1}{Constant mean function to be estimated}
\item{'t'}{Linear model for the mean function} \item{'avg'}{The average
across replications is used as the mean function. This is only used if
there are more than two realisations observed at the same input coordinate
values.} } Default to 0. If argument 'mu' is specified, then 'meanModel'
will be set to 'userDefined'.}

\item{mu}{Mean function specified by the user. It must be a vector. Its
length must be the same as the sample size, that is, nrow(response).}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}

\item{useGradient}{Logical. If TRUE, first derivatives will be used in the
optimization.}

\item{iter.max}{Maximum number of iterations allowed. Default to 100. If
'rel.tol' is reduced, then the number of iterations needed will be less.}

\item{rel.tol}{Relative convergence tolerance. Default to 8e-10. Smaller
rel.tol means higher accuracy and more time to converge.}

\item{trace}{The value of the objective function and the parameters is
printed every trace'th iteration. Defaults to 0 which indicates no trace
information is to be printed.}

\item{nInitCandidates}{Number of initial hyperparameter vectors. The
optimization starts with the best.}
}
\value{
A list containing: \describe{ \item{hyper}{Hyperparameters vector
  estimated from training data} \item{var.hyper}{ Variance of the estimated
  hyperparameters} \item{fitted.mean }{Fitted values for the training data }
  \item{fitted.sd }{Standard deviation of the fitted values for the training 
  data}
  \item{train.x }{ Training covariates} \item{train.y }{ Training response}
  \item{ train.yOri}{Original training response } \item{train.DataOri }{
  Original training covariates} \item{idxSubset }{Index vector identifying
  which observations were selected if Subset of Data was used.} \item{
  CovFun}{ Covariance function type} \item{ gamma}{Parameter used in powered
  exponential covariance function } \item{nu }{Parameter used in Matern
  covariance function } \item{Q}{Covariance matrix } \item{mean}{Mean
  function } \item{meanModel}{Mean model used} \item{meanLinearModel}{'lm'
  object if mean is a linear regression. NULL otherwise.} \item{conv}{An
  integer. 0 means converge; 1 otherwise. } \item{hyper0}{Starting point of
  the hyperparameters vector.} }
}
\description{
Gaussian process regression for a single or multiple independent
realisations.
}
\details{
The most important function of the package. It fits the GPR model
  and stores everything necessary for prediction. The optimization used in
  the function is 'nlminb'. The names for the hyperparameters should be:
  "linear.a" for linear covariance function, "pow.ex.w", "pow.ex.v" for power
  exponential, "rat.qu.s", "rat.qu.a" for rational quadratic, "matern.w",
  "matern.v" for Matern, "vv" for variance of Gaussian white noise. All
  hyperparameters should be in one list.
}
\examples{
## See examples in vignettes:

# vignette("gpr_ex1", package = "GPFDA")
# vignette("gpr_ex2", package = "GPFDA")
# vignette("co2", package = "GPFDA")
}
\references{
Shi, J. Q., and Choi, T. (2011), ``Gaussian Process Regression
  Analysis for Functional Data'', CRC Press.
}
