% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{input_plot}
\alias{input_plot}
\title{Plot input load by source}
\usage{
input_plot(annual_data, sh_file, basin_name, plot.type, coef_SD = 1)
}
\arguments{
\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{sh_file}{sf object. The spatial information.}

\item{basin_name}{character. The title of the plot.}

\item{plot.type}{character. Possible values: Bar plot ("B") or
Density plot (“D”).}

\item{coef_SD}{numeric. The standard deviation coefficient.}
}
\value{
No return value, called for the side effect of drawing a plot
}
\description{
A grouped barplot representing the average input load by source
for the whole basin or a three density plots showing the distribution of
nutrient sources (7 for nitrogen, 5 for phosphorous).
}
\examples{
# the data of the TN scenario
data(annual_data_TN)
data(sh_file)
# The name of the basin
basin_name <- "Lay"
# the barplot
input_plot(annual_data = annual_data_TN, basin_name = basin_name, plot.type = "B")
# the density plots
input_plot(annual_data_TN, sh_file, basin_name, "D")

}
