% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_hill.R
\name{fit_hill}
\alias{fit_hill}
\title{Fit 2- or 3-parameter Hill model}
\usage{
fit_hill(
  x,
  conc = "logc",
  resp = "resp",
  fixed_slope = TRUE,
  chem = NULL,
  assay = NULL
)
}
\arguments{
\item{x}{data frame of dose response data.}

\item{conc}{column name of base-10 log scaled concentration.}

\item{resp}{column name of response.}

\item{fixed_slope}{if TRUE, slope is fixed at 1.}

\item{chem}{(optional) column name of chemical identifiers.}

\item{assay}{(optional) column name of assay identifiers.}
}
\value{
data frame of fit parameters.
}
\description{
Fit 2- or 3-parameter Hill model
}
\details{
Optional \code{chem} and \code{assay} identifiers can be used to fit multiple
chemicals and/or assays. Returned columns \code{tp} is the top asymptote and
\code{logAC50} is the 50\% response concentration. If the computation of the
standard deviations of these two parameters fails, then the standard
deviation is set equal to the parameter estimate and is indicated by the
respective imputed flag being TRUE.
}
\examples{
# Multiple assays, multiple chemicals
df <- geo_tox_data$dose_response
fit_hill(df, assay = "endp", chem = "casn")

# Single assay, multiple chemicals
df <- geo_tox_data$dose_response |>
  dplyr::filter(endp == "TOX21_H2AX_HTRF_CHO_Agonist_ratio")
fit_hill(df, chem = "casn")

# Single assay, single chemical
df <- geo_tox_data$dose_response |>
  dplyr::filter(endp == "TOX21_H2AX_HTRF_CHO_Agonist_ratio",
                casn == "510-15-6")
fit_hill(df)
# 3-parameter Hill model
fit_hill(df, fixed_slope = FALSE)
}
