% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerCalc.R
\name{powerCalc}
\alias{powerCalc}
\title{Power Calculation from gene expression data information}
\usage{
powerCalc(
  countDat,
  smplDat,
  alpha = 0.05,
  thrsholdFC = 2,
  inptNoOfReplicates = 3,
  sims = 10
)
}
\arguments{
\item{countDat}{A matrix or data frame of raw count data where rows represent genes and columns represent samples.}

\item{smplDat}{A data frame of sample information, with at least a \code{condition} column that specifies the experimental condition of each sample.}

\item{alpha}{The significance level (FDR threshold) used to identify differentially expressed genes. Default is 0.05.}

\item{thrsholdFC}{The threshold for the absolute value of log2 fold change used to filter DEGs. Default is 2.}

\item{inptNoOfReplicates}{The input number of replicates based on which the power will be calculated. Default is 3.}

\item{sims}{The number of simulations to run for power calculation. Default is 10.}
}
\value{
A data frame containing the calculated power values and related parameters.
}
\description{
This function takes the required input information such as count data, sample data, etc. to calculate the power.
It filters the input count data, performs DESeq2 analysis to calculate differentially expressed genes (DEGs), and
then calculates the power of detecting these DEGs based on simulations.
}
\details{
Example files included with this package:
\itemize{
\item \code{exmplCountDat.csv}: A toy dataset with count data.
\item \code{exmplSampleDat.csv}: A sample dataset with metadata.
}

These files are stored in the \code{inst/extdata} directory and can be accessed
using the \code{system.file()} function in R.
}
\examples{
\donttest{
# Load example files
countDatPath <- system.file("extdata", "exmplCountDat.csv", package = "HEssRNA")
smplDatPath <- system.file("extdata", "exmplSampleDat.csv", package = "HEssRNA")

if (file.exists(countDatPath) && file.exists(smplDatPath)) {
  countDat <- read.csv(countDatPath)
  smplDat <- read.csv(smplDatPath)

  result <- powerCalc(countDat, smplDat)
  print(result$PowerResults)
} else {
  warning("Example data files not found.")
}
}

}
\references{
Bi et al. (2016) \doi{10.1186/s12859-016-0994-9}
Love et al. (2014) \doi{10.1186/s13059-014-0550-8}
}
