% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vol2area_rating}
\alias{vol2area_rating}
\title{Convert depressional storage volume to area}
\usage{
vol2area_rating(rating_curve, volumes, method = "linear")
}
\arguments{
\item{rating_curve}{Required. Data frame containing the variables \code{area} and \code{volume}.}

\item{volumes}{A scalar or vector of depression storage volumes.}

\item{method}{Method for interpolation. Default is \option{linear}. Alternatively, 
a spline can be fitted by specifying \code{method = "spline"} and any other options used by the function \code{spline}.}
}
\value{
Returns a scalar or vector of lake stages
}
\description{
Convert depressional storage volume to area
}
\examples{
{
rating_curve <- data.frame(area=1:10, volume=seq(10, 100, 10))
a <- vol2area_rating(rating_curve, 55)
}
}
\author{
Kevin Shook
}
\keyword{internal}
