% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFL.core_tf.R
\name{INFL.core_tf}
\alias{INFL.core_tf}
\title{Computes the triple filter core inflation}
\usage{
INFL.core_tf(subits.var, weights, smoo, inf = 20, sup = 20, wind = 12,
  x11 = NULL, ...)
}
\arguments{
\item{subits.var}{A \code{ts}. Subitems' variation.}

\item{weights}{A \code{ts}. Each subitem corresponding weights. If missing, all items get the
same weight.}

\item{smoo}{A \code{vector}. List of codes to be smoothed. If missing, no item will be smoothed.}

\item{inf}{An \code{integer}. Percentage lower tail cut. Predefined as 20.}

\item{sup}{An \code{integer}. Percentage upper tail cut. Predefined as 20.}

\item{wind}{An \code{integer}. The volatility's window size to be computed.}

\item{x11}{A \code{string}. If an empty string is passed as argument, the seasonal adjustment uses x11 methodology.}

\item{...}{arguments passed on to \link[seasonal]{seas} to compute the seasonal adjustment.}
}
\value{
A \code{ts} object.
}
\description{
Computes the triple filter core inflation
}
\examples{
ipca <- ipca_sub
INFL.core_tf(subits.var=ipca$ipca_ts, weights = ipca$weights_ts)



}
\keyword{core}
\keyword{filter}
\keyword{triple}
