% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubikClust.R
\name{rubikclust}
\alias{rubikclust}
\title{Unsupervised clustering to detect rough structures and outliers.}
\usage{
rubikclust(X, min.space = 0.4, rotation = TRUE)
}
\arguments{
\item{X}{A data matrix for which rows represent samples and the 3 columns
represent features. Missingness is not allowed.}

\item{min.space}{A value to specify a minimum space between 2 consecutive
projected values. Default = 0.4.}

\item{rotation}{To specify if rotation is enabled or not. Default = TRUE.}
}
\value{
The returned value is a vector of numbers representing cluster
memberships.
}
\description{
Handle and operate on Nx3 matrix, where N is the number of
samples and data are collected on 3 variables.
}
\details{
The function rubikClust is able to take up to 3 variables
(N x 3 matrix). In case, a matrix contains more than 3 columns, only the
first three columns are used; the other columns are ignored.
}
\examples{
#Load simulated dataset
data(example_SNP)

PCs <- cal.pc.linear(simsnp$snp, no.pc = 3)

#Run rubikclust with the default parameters
groups <- rubikclust(PCs$PC)
#Check clustering results
print(groups)

#Check cluster's distribution
table(groups)

#Check the plot, highlight the points according to the clustering result
mylabels <- paste0("group", as.factor(groups))
plot3views( PCs$PC, labels = mylabels)

#Run rubikclust with min.space = 0.02
groups <- rubikclust(PCs$PC, min.space = 0.02)
#Check clustering results
print(groups)

#Check cluster's distribution
table(groups)

#Check the plot, highlight the points according to the clustering result
mylabels <- paste0("group", as.factor(groups))
plot3views( PCs$PC, labels = mylabels)
}
