% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L2E_TF_lasso.R
\name{L2E_TF_lasso}
\alias{L2E_TF_lasso}
\title{Solution path of the L2E trend filtering regression with Lasso}
\usage{
L2E_TF_lasso(
  y,
  X,
  beta0,
  tau0,
  D,
  lambdaSeq,
  max_iter = 100,
  tol = 1e-04,
  Show.Time = TRUE
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix. Default is the identity matrix.}

\item{beta0}{Initial vector of regression coefficients, can be omitted}

\item{tau0}{Initial precision estimate, can be omitted}

\item{D}{The fusion matrix}

\item{lambdaSeq}{A decreasing sequence of values for the tuning parameter lambda, can be omitted}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}

\item{Show.Time}{Report the computing time}
}
\value{
Returns a list object containing the estimates for beta (matrix) and
tau (vector) for each value of the tuning parameter lambda,
the run time (vector) for each lambda,
and the sequence of lambda used in the regression (vector)
}
\description{
\code{L2E_TF_lasso} computes the solution path of the robust trend filtering regression under the L2 criterion with Lasso penalty
}
\examples{
## Completes in 10 seconds

set.seed(12345)
n <- 100
x <- 1:n
f <- matrix(rep(c(-2,5,0,-10), each=n/4), ncol=1)
y <- y0 <- f + rnorm(length(f))

## Clean Data
plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)

D <- myGetDkn(1, n)
lambda <- 10^seq(-1, -2, length.out=20)
sol <- L2E_TF_lasso(y=y, D=D, lambdaSeq=lambda)

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)
lines(x, sol$Beta[,1], col='blue', lwd=3) ## 1st lambda

## Contaminated Data
ix <- sample(1:n, 10)
y[ix] <- y0[ix] + 2

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)

sol <- L2E_TF_lasso(y=y, D=D, lambdaSeq=lambda)

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)
lines(x, sol$Beta[,1], col='blue', lwd=3) ## 1st lambda

}
