% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object-svd-like.R
\name{svd_like}
\alias{svd_like}
\title{Create a SVD-like low rank matrix factorization object}
\usage{
svd_like(u, d, v, subclasses = NULL, ...)
}
\arguments{
\item{u}{A \emph{matrix} "left singular-ish" vectors.}

\item{d}{A \emph{vector} of "singular-ish" values.}

\item{v}{A \emph{matrix} of "right singular-ish" vectors.}

\item{subclasses}{A character vector of subclasses.
Optional, defaults to \code{NULL}.}

\item{...}{Optional additional items to pass to the constructor.}
}
\description{
A low rank matrix factorization of a matrix \code{X} is
parameterized by \verb{X ~= u \%*\% diag(d) \%*\% t(v)}. The
object is "svd-like" because the middle matrix in
the decomposition must be strictly diagonal.
}
\examples{

s <- svd(as.matrix(trees))

# using the constructor directly
svd_like(s$u, s$d, s$v)

# coercing svd-like lists
as_svd_like(s)

}
