% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNormTest.R
\name{covTest.single}
\alias{covTest.single}
\title{Single Covariance Matrix Hypothesis Testing}
\usage{
covTest.single(data, Sigma0, ball = FALSE, alpha = 0.05, verbose = TRUE)
}
\arguments{
\item{data}{The data matrix which is a matrix or data frame.}

\item{Sigma0}{The covariance matrix when the null hypothesis is true.}

\item{ball}{A boolean value. Default is FALSE. If FALSE, test whether the covariance matrix is Sigma0 (known), which means the null hypothesis is "H0: Sigma = Sigma0". If TRUE and the Sigma0 is a unit matrix, the Mauchly's ball test will be performed. If TRUE but Sigma0 (known) is not a unit matrix, the covariance matrix will be tested to see if it is sigma^2*Sigma0 (sigma^2 is unknown), which means the null hypothesis is "H0: Sigma = sigma^2 * Sigma0".}

\item{alpha}{The significance level. Default is 0.05.}

\item{verbose}{A boolean value. Default is TRUE. If TRUE, the null hypothesis will be displayed. If FALSE, the test will be carried out silently.}
}
\value{
An object of class "testResult", which is a list with the following elements:
Return when ball is FALSE.
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMean}{The sample mean.}
\item{SampA}{The sample deviation.}
\item{Df}{The degree of freedom.}
Return when ball is TRUE
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMean}{The sample mean.}
\item{SampA}{The sample deviation.}
\item{sigma.hat}{The estimation of sigma^2.}
\item{Df}{The degree of freedom.}
}
\description{
Test whether the covariance matrix is equal to a certain value. The null hypothesis is "H0: Sigma = Sigma0" or "H0: Sigma = sigma^2 * Sigma0".
}
\examples{
data(iris)
X <- iris[, 1:4]
# carry out the test
test1 <- covTest.single(X, diag(1, 4))
test2 <- covTest.single(X, diag(1, 4), ball = TRUE)
test3 <- covTest.single(X, diag(2, 4), ball = TRUE)
test4 <- covTest.single(X, diag(1, 4), verbose = FALSE)
# get the elements
test1$Stat
test2$Df
test3$sigma.hat
}
\references{
Huixuan, Gao. Applied Multivariate Statistical Analysis. Peking University Press, 2005: pp.83-88.
}
\author{
Xifeng Zhang
}
