#' Compute Score Matrix
#'
#' This function adjusts an original matrix by copying the lower triangular part from a shifted matrix.
#'
#' @param original_matrix A numeric matrix representing the original data.
#' @param shifted_matrix A numeric matrix that has been transformed using `shift_matrix()`.
#' @return A new matrix with adjusted values in the lower triangular part.
#' @export
score_matrix <- function(original_matrix, shifted_matrix) {
  # Create a copy of the original matrix
  new_matrix <- original_matrix

  # Get the number of rows in the matrix
  n <- nrow(original_matrix)

  # Iterate over rows and columns to copy the lower triangular part
  for (i in 2:n) {
    for (j in 1:(i - 1)) {
      new_matrix[i, j] <- shifted_matrix[i, j]
    }
  }

  # Set diagonal to zero
  diag(new_matrix) <- 0

  return(new_matrix)
}
