\name{MaxInteraction.plot}
\alias{MaxInteraction.plot}
\title{
Interaction Plot to understand the nature of row-by-column clusters interaction against the optimal choice of (\eqn{P}) and (\eqn{Q}).
}
\description{
Generates an interaction plot based on a given interaction matrix (\code{Gamma_matrix}) resulting from a two-mode clustering analysis. The plot displays estimated interaction effects
for the optimal combination of row and column clusters.
}
\usage{
MaxInteraction.plot(Gamma_matrix, row_counts = NULL)
}
\arguments{
  \item{Gamma_matrix}{
A numeric matrix containing estimated interaction effects (\eqn{\Gamma}) between row clusters (e.g., participants) and column clusters (e.g., tasks or items). 
Rows correspond to row clusters, and columns correspond to column clusters.
}
  \item{row_counts}{
An optional numeric vector containing the number of observations (e.g., participants) in each row cluster. If provided, this information is added as a caption in the plot.
}
}
\details{
The function creates a line plot for each row cluster, where the x-axis corresponds to column clusters and the y-axis to estimated interaction values (\eqn{\Gamma}). The function automatically
assigns generic names (\code{Row Cluster 1, Row Cluster 2, ...}) and (\code{Column Cluster 1, Column Cluster 2, ...}) if row or column names are not provided.

If \code{row_counts} is supplied, a caption is added to indicate the number of observations per row cluster.
}
\value{
A \code{ggplot} object displaying the interaction plot. The function does not return any additional values.
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function is intended for visualizing the interaction matrix obtained after selecting the optimal number of row and column clusters (\eqn{P}, \eqn{Q}) 
using \code{MaxInt_data_analysis} and \code{MaxInt.Screeplot}.
}
\seealso{
\code{\link{MaxInt_data_analysis}}, \code{\link{screeplot.MaxInt_data_analysis}}
}
\examples{
Gamma_matrix <- matrix(c(0.5, 0.8, -0.2,
                         0.1, 0.3, 0.6,
                         -0.4, 0.2, 0.7),
                       nrow = 3, byrow = TRUE)
rownames(Gamma_matrix) <- c("High", "Low", "Intermediate")
colnames(Gamma_matrix) <- c("Task 1", "Task 2", "Task 3")
MaxInteraction.plot(Gamma_matrix, row_counts = c(50, 40, 60))
}
\keyword{Permutation based inference}
\keyword{REMAXINT and E-ReMI}
\keyword{visualization optimal interaction}
