\name{Update_row_clusters_E_ReMI}
\alias{Update_row_clusters_E_ReMI}
\title{
Update Row Cluster Assignments in E-ReMI clustering framework. 
}
\description{
Updates the row cluster membership matrix within the E-ReMI algorithm by maximizing the log-likelihood for each row based on the current estimates of model parameters.
}
\usage{
Update_row_clusters_E_ReMI(DC, I, J, P, 
Updated_R, Updated_C, Updated_omegahat, 
Updated_G, 
Updated_sigma)
}
\arguments{
  \item{DC}{
  A doubly centered numeric matrix of dimension \code{I x J} representing the data matrix to be clustered.
}
  \item{I}{
  An integer specifying the number of rows (objects) in the data matrix.
}
  \item{J}{
  An integer specifying the number of columns (features) in the data matrix.
}
  \item{P}{
  An integer specifying the number of row clusters.
}
  \item{Updated_R}{
  A binary \code{I x P} matrix representing the current row cluster membership matrix.
}
  \item{Updated_C}{
  A binary \code{J x Q} matrix representing the current column cluster membership matrix.
}
  \item{Updated_omegahat}{
  A numeric vector of length \code{P} representing the current estimated mixing proportions for row clusters.
}
  \item{Updated_G}{
  A numeric matrix of dimension \code{P x Q} representing the current latent structure or interaction pattern between row and column clusters.
}
  \item{Updated_sigma}{
  A numeric value representing the current estimate of error variance or noise parameter in the model.
}
}
\details{
This function iteratively updates the row cluster assignments for each row in the data matrix \code{DC}. For each row, it evaluates the log-likelihood 
of assignment to all possible clusters and updates the cluster membership to the one that maximizes the likelihood. Singleton constraints are respected 
to avoid assigning rows to clusters that would result in empty or singleton groups.
}
\value{
A binary matrix of the same dimensions as \code{Updated_R}, representing the updated row cluster membership after one iteration of the E-ReMI update step.
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function is a part of the E-ReMI clustering framework. 
}
\seealso{
\code{\link{E_ReMI}}, \code{\link[pracma]{pinv}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2
DC <- matrix(rnorm(I*J), I, J)
Updated_R <- diag(1, I, P)
Updated_C <- diag(1, J, Q)
Updated_omegahat <- c(0.5, rep((1-0.5)/P, P))
R_pinv <- pracma::pinv(t(Updated_R) \%*\% Updated_R)
C_pinv <- pracma::pinv(t(Updated_C) \%*\% Updated_C)
Updated_G <- R_pinv \%*\% t(Updated_R) \%*\% DC \%*\% Updated_C \%*\% C_pinv
Updated_G <- as.matrix(Updated_G)
Updated_M <- Updated_R \%*\% Updated_G \%*\% t(Updated_C)
Updated_sigma <- sum((DC - Updated_M)^2)/(I*J)
result <- Update_row_clusters_E_ReMI(
  DC, I, J, P,
  Updated_R, Updated_C,
  Updated_omegahat, Updated_G,
  Updated_sigma
)
result
}
\keyword{updating row cluster membership in E-ReMI}
