\name{screeplot.MaxInt_data_analysis}
\alias{screeplot.MaxInt_data_analysis}
\title{
Scree Plot for Maximal Interaction Two-Mode Clustering Results
}
\description{
Generates a scree plot showing the interaction Explained Sum of Squares (iESS) for different combinations of latent row and column clusters in the Maximal Interaction two-mode clustering analysis.
}
\usage{
\method{screeplot}{MaxInt_data_analysis}(x, ...)
}
\arguments{
  \item{x}{
An object of class \code{MaxInt_data_analysis}, typically returned by the function that performs the Maximal Interaction two-mode clustering. It should contain a list element \code{Gamma_results} with rows \code{P}, columns \code{Q}, and cell entries \code{Gamma_value}.
}
  \item{\dots}{
Additional graphical parameters passed to the underlying \code{plot} function.
}
}
\details{
This function helps visualize how the interaction Explained Sum of Squares (iESS) varies across different combinations of latent row and column cluster numbers, \code{P} and \code{Q}, by plotting their product \eqn{(P - 1)(Q - 1)} on the x-axis and the corresponding iESS on the y-axis. This plot aids in selecting the optimal number of latent row by column clusters.
}
\value{
Returns a base R plot object for visual inspection. No return value is assigned invisibly.

If needed, additional customization can be applied using graphical parameters through the \code{\dots} argument.
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
Ensure that the input object contains a properly structured \code{Gamma_results} data frame. Use this plot to inform your choice of latent clusters.
}
\seealso{
\code{\link{MaxInt_data_analysis}}, \code{\link{MaxInteraction.plot}}
}
\examples{
set.seed(123)
set.seed(123)
Data <- matrix(rnorm(60), nrow = 10, ncol = 6)
Clus <- matrix(c(2,2, 2,3, 3,2), ncol = 2, byrow = TRUE)
result <- MaxInt_data_analysis(Data, Clus, Nruns = 5, permutations = 10, alpha_level = 0.05)
screeplot(result)
}
\keyword{optimal clustering}
\keyword{visualization}