% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_clr-methods.R
\docType{methods}
\name{mr_clr}
\alias{mr_clr}
\alias{mr_clr,MRInput-method}
\title{Conditional likelihood ratio (CLR) method}
\usage{
mr_clr(object, nx, ny, alpha = 0.05, CIMin = -10, CIMax = 10, CIStep = 0.01)

\S4method{mr_clr}{MRInput}(object, nx, ny, alpha = 0.05, CIMin = -10, CIMax = 10, CIStep = 0.01)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{nx}{The sample size used to compute genetic associations with the exposure.}

\item{ny}{The sample size used to compute genetic associations with the outcome.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}

\item{CIMin}{The smallest value to use in the search to find the confidence interval (default is -10).}

\item{CIMax}{The largest value to use in the search to find the confidence interval (default is +10).}

\item{CIStep}{The step size to use in the search to find the confidence interval (default is 0.01). Using a lower value (such as 0.001) will give more precise confidence intervals, but increase run time.}
}
\value{
The output from the function is an \code{CLR} object containing:

 \item{Exposure}{A character string with the name given to the exposure.}
 \item{Outcome}{A character string with the names given to the outcome.}
 \item{Correlation}{The matrix of genetic correlations.}
 \item{ARlower}{The lower bounds of the causal estimate based on inverting Anderson and Rubin's test.}
 \item{ARupper}{The upper bounds of the causal estimate based on inverting Anderson and Rubin's test.}
 \item{Klower}{The lower bounds of the causal estimate based on inverting Kleibergen's test.}
 \item{Kupper}{The upper bounds of the causal estimate based on inverting Kleibergen's test.}
 \item{CLRlower}{The lower bounds of the causal estimate based on inverting Moreira's conditional likelihood ratio test.}
 \item{CLRupper}{The upper bounds of the causal estimate based on inverting Moreira's conditional likelihood ratio test.}
 \item{CIMin}{The smallest value used in the search to find the confidence interval.}
 \item{CIMax}{The largest value used in the search to find the confidence interval.}
 \item{CIStep}{The step size used in the search to find the confidence interval.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
}
\description{
The \code{mr_clr} function calculates confidence intervals based on inverting the conditional likelihood ratio and other identification-robust tests.
}
\details{
In weak instrument settings, usual inference based on point estimates and standard errors may not be accurate. This method calculates confidence intervals based on inverting identification-robust tests proposed in Wang and Kang (2021, Biometrics) that provide valid inferences regardless of instrument strength.

This includes conditional likelihood ratio (CLR), Kleibergen (K), and Anderson and Rubin (AR) tests.

Evidence from the econometrics literature suggests that CLR inference is the best option in terms of power under a wide range of settings.

Please note that these methods do not provide point estimates, only confidence intervals. While most examples provide a confidence interval that is a single range of values, in some cases the confidence interval may comprise multiple ranges of values. In other cases, a valid confidence interval may not exist.
}
\examples{
mr_clr(mr_input(bx = calcium, bxse = calciumse,
   by = fastgluc, byse = fastglucse, correl = calc.rho), nx=6351, ny=133010)

}
\references{
Description of the CLR method: "Weak-instrument robust tests in two-sample summary-data Mendelian randomization", S. Wang and H. Kang, Biometrics, 2021.
}
