% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta3dMainF.R
\name{meta3d}
\alias{meta3d}
\title{Detect rhythmic signals from time-series datasets with individual
  information}
\usage{
meta3d(datafile, designfile, outdir = "metaout", filestyle,
  design_libColm, design_subjectColm, minper = 20, maxper = 28,
  cycMethodOne = "JTK", timeUnit = "hour", design_hrColm,
  design_dayColm = NULL, design_minColm = NULL,
  design_secColm = NULL, design_groupColm = NULL,
  design_libIDrename = NULL, adjustPhase = "predictedPer",
  combinePvalue = "fisher", weightedMethod = TRUE,
  outIntegration = "both", ARSmle = "auto", ARSdefaultPer = 24,
  dayZeroBased = FALSE, outSymbol = "", parallelize = FALSE,
  nCores = 1)
}
\arguments{
\item{datafile}{a character string. The name of data file containing
time-series experimental values of all individuals.}

\item{designfile}{a character string. The name of experimental design file,
at least containing the library ID(column names of \code{datafile}),
subject ID(the individual corresponding to each library ID), and
sampling time information of each library ID.}

\item{outdir}{a character string. The name of directory used to store
output files.}

\item{filestyle}{a character vector(length 1 or 3). The data format of
input files, must be \code{"txt"}, or \code{"csv"}, or a character
vector containing field separator character(\code{sep}), quoting
character(\code{quote}), and the character used for decimal
points(\code{dec}, for details see \code{\link[utils]{read.table}}).}

\item{design_libColm}{a numeric value. The order index(from left to right)
of the column storing library ID in \code{designfile}.}

\item{design_subjectColm}{a numeric value. The order index(from left to
right) of the column storing subject ID in \code{designfile}.}

\item{minper}{a numeric value. The minimum period length of interested
rhythms. The default is \code{20} for circadian rhythms.}

\item{maxper}{a numeric value. The maximum period length of interested
rhythms. The default is \code{28} for circadian rhythms.}

\item{cycMethodOne}{a character string. The selected method for analyzing
time-series data of each individual, must be one of \code{"ARS"}(ARSER),
\code{"JTK"}(JTK_CYCLE), or \code{"LS"}(Lomb-Scargle).}

\item{timeUnit}{a character string. The basic time-unit, must be one of
\code{"day"}, \code{"hour"}(default for circadian study),
\code{"minute"}, or \code{"second"} depending on specific experimental
design.}

\item{design_hrColm}{a numeric value. The order index(from left to right)
of the column storing time point value-sampling hour information in
\code{designfile}. If there is no such column in \code{designfile},
set it as \code{NULL}.}

\item{design_dayColm}{a numeric value. The order index(from left to right)
of the column storing time point value-sampling day information in
\code{designfile}. If there is no such column in \code{designfile},
set it as \code{NULL}(default).}

\item{design_minColm}{a numeric value. The order index(from left to right)
of the column storing time point value-sampling minute information in
\code{designfile}. If there is no such column in \code{designfile},
set it as \code{NULL}(default).}

\item{design_secColm}{a numeric value. The order index(from left to right)
of the column storing time point value-sampling second information in
\code{designfile}. If there is no such column in \code{designfile},
set it as \code{NULL}(default).}

\item{design_groupColm}{a numeric value. The order index(from left to
right) of the column storing experimental group information of each
individual in \code{designfile}. If there is no such column in
\code{designfile}, set it as \code{NULL}(default) and take all
individuals as one group.}

\item{design_libIDrename}{a character vector(length 2) containing  a
matchable character string in each library ID of \code{designfile}, and
a replacement character string. If it is not necessary to replace
characters in library ID of \code{designfile}, set it as \code{NULL}(
default).}

\item{adjustPhase}{a character string. The method used to adjust each
calculated phase before getting integrated phase, must be one of
\code{"predictedPer"}(adjust phase with predicted period length)
or \code{"notAdjusted"}(not adjust phase).}

\item{combinePvalue}{a character string. The method used to integrate
p-values of multiple individuals, currently only \code{"fisher"}(
Fisher's method) could be selected.}

\item{weightedMethod}{logical. If \code{TRUE}(default), weighted score
based on p-value of each individual will be used to integrate period,
phase and amplitude values of multiple individuals.}

\item{outIntegration}{a character string. This parameter controls what
kinds of analysis results will be outputted, must be one of
\code{"both"}, \code{"onlyIntegration"}, or \code{"noIntegration"}.
See \code{\link{meta2d}} for more information.}

\item{ARSmle}{a character string. The strategy of using MLE method in
\code{"ARS"}, must be one of \code{"auto"}, \code{"mle"}, or
\code{"nomle"}. See \code{\link{meta2d}} for more information.}

\item{ARSdefaultPer}{a numeric value. The expected period length of
interested rhythm, which is a necessary parameter for \code{ARS}. See
\code{\link{meta2d}} for more information.}

\item{dayZeroBased}{logical. If \code{TRUE}, the first sampling day is
recorded as day zero in the \code{designfile}.}

\item{outSymbol}{a character string. A common prefix exists in the names of
output files.}

\item{parallelize}{logical. If \code{TRUE}, computation will be done in paralleL
Doesn't work in windows machine}

\item{nCores}{a integer. Bigger or equal to one, number of cores to use}
}
\value{
\code{meta3d} will write analysis results to \code{outdir} instead of
  returning them as objects. Output files with "meta3dSubjectID" in
  the file name are analysis results for each individual. Files named with
  "meta3dGroupID" store integrated p-values, period, phase, baseline,
  amplitude and relative amplitude values from multiple individuals of
  each group and calculated FDR values based on integrated p-values.
}
\description{
This is a function that takes use of any one method from ARSER, JTK_CYCLE
  and Lomb-Scargle to detect rhythmic signals from time-series datasets
  containing individual information.
}
\details{
This function is originally aimed to analyze large scale periodic data with
  individual information. Please pay attention to the data format of
  \code{datafile} and \code{designfile}(see \code{Examples} part).
  Time-series experimental values(missing values as \code{NA}) from
  all individuals should be stored in \code{datafile}, with the first row
  containing all library ID(unique identification number for each sample)
  and the first column containing all detected molecular names(eg.
  transcript or gene name). The \code{designfile} should at least have
  three columns-library ID, subject ID and sampling time column.
  Experimental group information of each subject ID may be in another
  column. In addition, sampling time information may be stored in multiple
  columns instead of one column. For example, sampling time-"36 hours" may
  be recorded as "day 2"(sampling day column, \code{design_dayColm}) plus
  "12 hours"(sampling hour column, \code{design_hrColm}). The library ID
  in \code{datafile} and \code{designfile} should be same. If there are
  different characters between library ID in these two files, try
  \code{design_libIDrename} to keep them same.

\code{ARS}, \code{JTK} or \code{LS} could be used to analyze time-series
  profiles individual by individual. \code{meta3d} requires that all
  individuals should be analyzed by the same method before integrating
  calculated p-value, period, phase, baseline value, amplitude and relative
  amplitude values group by group. However, the sampling pattern among
  individuals may be different and the requirement of sampling pattern for
  each method is not same(see more information about these methods and their
  limitations in \code{\link{meta2d}}). Please carefully select a proper
  method for the specific dataset. \code{meta3d} also help users select
  the suitable method through warning notes.

P-values from different individuals are integrated with Fisher's method
  (\code{"fisher"})(Fisher,1925; implementation code from \pkg{MADAM}).For
  short time-series profiles(eg. 10 time points or less), p-values given by
  Lomb-Scargle may be over conservative, which will also lead to
  conservative integrated p-values. The integrated period, baseline,
  amplitude and relative amplitude values are arithmetic mean of multiple
  individuals, respectively. The phase is
  \href{https://en.wikipedia.org/wiki/Mean_of_circular_quantities}{
  mean of circular quantities}(\code{adjustPhase = "predictedPer"})
  or a arithmetic mean (\code{adjustPhase = "notAdjusted"}) of multiple
  individual phases. For completely removing the potential problem of
  averaging phases with quite different period length(also mentioned
  in \code{\link{meta2d}}), setting \code{minper}, \code{maxper} and
  \code{ARSdefaultPer} to a same value may be the only known way. If
  \code{weightedMethod = TRUE} is selected, weighted scores(
  \code{-log10(p-values)}) will be taken into account in integrating
  period, phase, baseline, amplitude and relative amplitude.
}
\examples{
# write 'cycHumanBloodData' and 'cycHumanBloodDesign' into two 'csv' files
write.csv(cycHumanBloodData, file="cycHumanBloodData.csv",
  row.names=FALSE)
write.csv(cycHumanBloodDesign, file="cycHumanBloodDesign.csv",
  row.names=FALSE)

# detect circadian transcripts with JTK in studied individuals
meta3d(datafile="cycHumanBloodData.csv", cycMethodOne="JTK",
  designfile="cycHumanBloodDesign.csv", outdir="example",
  filestyle="csv", design_libColm=1, design_subjectColm=2,
  design_hrColm=4, design_groupColm=3)
}
\references{
Glynn E. F., Chen J., and Mushegian  A. R. (2006). Detecting periodic
  patterns in unevenly spaced gene expression time series using
  Lomb-Scargle periodograms. \emph{Bioinformatics}, \bold{22(3)},
  310--316

Fisher, R.A. (1925). \emph{Statistical methods for research workers}.
  Oliver and Boyd (Edinburgh).

Kugler K. G., Mueller L.A., and Graber A. (2010). MADAM - an open source
  toolbox for meta-analysis. \emph{Source Code for Biology and Medicine},
  \bold{5}, 3.
}
