% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_remove_outliers.R
\name{miRNA_removeOutliers}
\alias{miRNA_removeOutliers}
\title{Removal of dataset outliers.}
\usage{
miRNA_removeOutliers(inputDataset, qualityThresholdFrame)
}
\arguments{
\item{inputDataset}{Dataset (data frame) to be cleaned of outliers. The data frame must comply with the output format of the preprocessing function (miRNA_expressionPreprocessing), thus containing the columns 'Subject', 'miRNA', 'Mean', 'StdDev', 'SampleSize' and possibly 'Class'. Any other column is ignored, and any missing column forbids execution.}

\item{qualityThresholdFrame}{Critical sigma values (data frame) to be used. The data frame must comply with the output format of the ebbc function for critical sigma assessment (miRNA_assessQualityThreshold), thus containing the columns 'miRNA' and 'QualityThreshold'. Any other column is ignored, and any missing column forbids execution.

Beware! Entries of the dataset for which 'miRNA' is not present in the data frame of critical sigma values are copied in output without any filtering.}
}
\value{
A data frame corresponding to a copy of the input dataset devoid of outliers. The output data frame thus contains the columns 'Subject', 'miRNA', 'Mean', 'StdDev', 'Variance', 'SampleSize' and possibly 'Class'.

Please refer to the user manual installed in "/path-to-library/MiRNAQCD/doc/manual.pdf" for detailed function documentation. The path "/path-to-library" can be shown from R by calling ".libPaths()"
}
\description{
This function removes outliers from a given dataset according to a set of quality threshold values.
}
\examples{
requiredDataFile = paste(system.file(package="MiRNAQCD"),
		"/extdata/test_dataset_alpha_prep.dat", sep='')
myDataFrame <- read.table(file=requiredDataFile, header=TRUE)
requiredQtFile = paste(system.file(package="MiRNAQCD"),
		"/extdata/test_dataset_alpha_qt.dat", sep='')
qtDataFrame <- read.table(file=requiredQtFile, header=TRUE)
myDataFrameCleaned <- miRNA_removeOutliers(myDataFrame, qtDataFrame)
}
