% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lasoelascox.R
\name{Lasoelascox}
\alias{Lasoelascox}
\title{Wapper function for glmnet}
\usage{
Lasoelascox(
  Survival,
  Censor,
  Micro.mat,
  Prognostic,
  Plots = FALSE,
  Standardize = TRUE,
  Alpha = 1,
  Fold = 4,
  nlambda = 100,
  Mean = TRUE,
  Quantile = 0.5
)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Censor}{A vector of censoring indicator}

\item{Micro.mat}{A large or small microbiome matrix. A matrix with microbiome profiles where the number of rows is equal to the number of taxa and number of columns is equal to number of patients.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Plots}{A boolean parameter indicating if plots should be shown. Default is FALSE. If TRUE, the first plot is the partial likelihood deviance against the logarithmn of each lambda while the second is the coefficients versus the lambdas}

\item{Standardize}{A Logical flag for the standardization of the microbiome matrix, prior to fitting the model sequence. The coefficients are always returned on the original scale. Default is standardize=TRUE.}

\item{Alpha}{The mixing parameter for glmnet (see \code{\link[glmnet]{glmnet}}). The range is 0<= Alpha <= 1. The Default is 1}

\item{Fold}{number of folds to be used for the cross validation. Its value ranges between 3 and the number of subjects in the dataset}

\item{nlambda}{The number of lambda values - default is 100 as in glmnet.}

\item{Mean}{The cut off value for the classifier, default is the mean cutoff}

\item{Quantile}{If user want to use quantile as cutoff point. They need to specify Mean = FALSE and a quantile that they want to use. The default is the median cutoff}
}
\value{
A object is returned with the following values
  \item{Coefficients.NonZero}{The coefficients of the selected taxa}
  \item{Selected.Mi}{The selected taxa}
  \item{n}{The number of selected taxa}
  \item{Risk.scores}{The risk scores of the subjects}
  \item{Risk.group}{The risk classification of the subjects based on the specified cutoff point}
  \item{SurvFit}{The cox analysis of the riskgroup based on the selected taxa and the prognostic factors}
}
\description{
The function uses the glmnet function to firstly do the variable selection either with Lasso, Elastic net or ridge regressions before the survial analysis.
The survival analysis is based on the selected taxa in the presence or absence of prognostic factors.
}
\details{
This is a wrapper function for glmnet and it fits models using either Lasso, Elastic net and Ridge regressions.
This is done in the presence or absence of prognostic factors.
The prognostic factor when available will always be forced to be in the model so no penalty for it.
Optimum lambda will be used to select the non-zero shrinkage coefficients, the nonzero selceted taxa will thus be used in the survival analysis and in calculation of the risk scores.
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the function
lasso_fam_shan_w3 = Lasoelascox(Survival = surv_fam_shan_w3$Survival,
                                Censor = surv_fam_shan_w3$Censor,
                                Micro.mat = fam_shan_trim_w3,
                                Prognostic = prog_fam_shan_w3,
                                Plots = TRUE,
                                Standardize = TRUE,
                                Alpha = 1,
                                Fold = 4,
                                nlambda = 100,
                                Mean = TRUE)

# View the selected taxa
lasso_fam_shan_w3$Selected.mi

# Number of selected taxa
lasso_fam_shan_w3$n

# View the classification group of each subject
lasso_fam_shan_w3$Risk.Group

# View the survival analysis result
lasso_fam_shan_w3$SurvFit
}
\seealso{
\code{\link[survival]{coxph}}

\code{\link[survival]{coxph}},
\code{\link[MicrobiomeSurv]{EstimateHR}},
\code{\link[glmnet]{glmnet}},
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
