% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms-class.R
\docType{class}
\name{ms-class}
\alias{ms-class}
\alias{ms}
\alias{show,ms-method}
\alias{ms,ANY}
\alias{summary,ms-method}
\alias{plot,ms,ANY-method}
\alias{ms-method}
\title{The ms Class.}
\usage{
\S4method{show}{ms}(object)

\S4method{summary}{ms}(object)

\S4method{plot}{ms,ANY}(x, y, ...)
}
\arguments{
\item{object}{A ms class object}

\item{x}{A ms class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{MSpecificCoxPh}}.
plot signature(x = "ms"): Plots for ms class analysis results
}
\details{
Any parameters of \code{\link[graphics]{plot.default}} may be passed on to this particular plot method.

show(ms-object)
}
\section{Slots}{

\describe{
\item{\code{Result}}{A list of dataframes of each output object of coxph for the taxa.}

\item{\code{HRRG}}{A dataframe with estimated taxon-specific HR for low risk group and 95 percent CI.}

\item{\code{Group}}{A matrix of the classification group a subject belongs to for each of the taxon analysis. The taxa are on the rows and the subjects are the columns}

\item{\code{Mi.names}}{The names of the taxon for the analysis}
}}

\seealso{
\code{\link[MicrobiomeSurv]{MSpecificCoxPh}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
