% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{plot_SCBD_pq}
\alias{plot_SCBD_pq}
\title{Plot species contributions to beta diversity (SCBD) of samples}
\usage{
plot_SCBD_pq(
  physeq,
  tax_level = "Taxa",
  tax_col = "Order",
  min_SCBD = 0.01,
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{tax_level}{Taxonomic level to used in y axis}

\item{tax_col}{Taxonomic level to colored points}

\item{min_SCBD}{(default 0.01) the minimum SCBD value
to plot the taxa}

\item{...}{Additional arguments passed on to \code{\link[adespatial:beta.div]{adespatial::beta.div()}} function}
}
\value{
A ggplot2 object build with the package patchwork
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


A wrapper for the \code{\link[adespatial:beta.div]{adespatial::beta.div()}} function in the case of \code{physeq}
object.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{vegan::beta.div()} if you
use this function.
}
\examples{
data(data_fungi)
if (requireNamespace("adespatial")) {
  plot_SCBD_pq(data_fungi) +
    geom_text(aes(label = paste(Genus, Species)), hjust = 1, vjust = 2) +
    xlim(c(0, NA))
}
\donttest{
if (requireNamespace("adespatial")) {
  plot_SCBD_pq(data_fungi, tax_level = "Class", tax_col = "Phylum", min_SCBD = 0) +
    geom_jitter()
}
}

}
\seealso{
\link{LCBD_pq}, \code{\link[adespatial:beta.div]{adespatial::beta.div()}}
}
\author{
Adrien Taudière
}
