% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.11.main.R
\name{summary.mmcsd.theta}
\alias{summary.mmcsd.theta}
\title{Summarise the results of 'cov_mmcsd' fit.}
\usage{
\method{summary}{mmcsd.theta}(object, ...)
}
\arguments{
\item{object}{A mmcsd.theta fitted model}

\item{...}{Additional params passed to summary}
}
\value{
Return NULL and print in terminal the results.
}
\description{
Summarise the results of 'cov_mmcsd' fit.
}
\examples{
\donttest{
fit <- mmcsd(
 score ~ wave + ageg + ecacg + qualifg,
 waves = wave, ids = id,
 weights = weight, stratum = strata, cluster = cluster,
 data = example_data, sigma = "exchangeable"
)
fitTheta_ucm <- cov_mmcsd(fit,
 fittingType = "PML", sigmaThetaExpr = "UCM",
 optimParams = list(par = c(7, 5))
)
summary(fitTheta_ucm)

}
}
