% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_outcome_difference.R
\name{MeanOutcomeDifference}
\alias{MeanOutcomeDifference}
\title{Mean Outcome Difference Importance Function}
\usage{
MeanOutcomeDifference(
  X,
  Y,
  sample_size = trunc(nrow(X) * 0.8),
  num_trees = 100,
  m_feature = ncol(X),
  min_leaf = 10,
  alpha_threshold = 0
)
}
\arguments{
\item{X}{Feature matrix}

\item{Y}{Target matrix}

\item{sample_size}{Size of random subset for each tree generation}

\item{num_trees}{Number of Trees to generate}

\item{m_feature}{Number of randomly selected features considered for a split in each regression tree node, which
must be positive integer and less than N (number of input features)}

\item{min_leaf}{Minimum number of samples in the leaf node. If a node has less than or equal
to min_leaf samples, then there will be no splitting in that node and this node
will be considered as a leaf node. Valid input is positive integer, which is less
than or equal to M (number of training samples)}

\item{alpha_threshold}{threshold for split significant testing. If default value of 0 is specified,
all the node splits will contribute to result, otherwise only those splits with improvement greater
than 1-alpha critical value of an f-statistic do.}
}
\value{
Vector of size N x 1
}
\description{
Mean Outcome Difference Importance Function
}
\details{
For each split defined by feature j, the mean outcome difference importance function calculates the absolute
difference in mean values per outcome between the left and right children nodes of the resultant split. With a
multivariate outcome vector, this measure thus gives a vector of importance measures for feature j, i.e., it returns
an outcome specific importance measure for feature j. If feature j is used in splitting M nodes of the tree, the
resulting tree-specific importance measure is the sum of the node-specific absolute differences in mean nodal
values per outcome calculated across all M nodes. For the multivariate random forest, the mean outcome difference
importance measure for feature j is the average of the tree-specific measures across all trees in the forest.

If the alpha threshold is 0 all the splits defined by feature j will be used in computing the importance measure.
The user also has the option of including only the significant node splits defined by feature j in the calculation
of the importance measure.  The significance of node splits is measured using an F-test. In this case, the user will
matrix and the number of left and right node samples for the given node split.

Segal MR (1992) Tree-structured methods for longitudinal data. J. American Stat. Assoc. 87(418), 407-418.
}
\examples{
X = matrix(runif(50*5), 50, 5)
Y = matrix(runif(50*2), 50, 2)
MeanOutcomeDifference(X, Y)
}
