# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' C++ implementation of the F-measure computation
#'
#'@param pred vector of a predicted partition
#'@param ref vector of a reference partition
#'
#'@export
#'
#'@examples
#'pred <- c(1,1,2,3,2,3)
#'ref <- c(2,2,1,1,1,3)
#'FmeasureC(pred, ref)
#'
FmeasureC <- function(pred, ref) {
    .Call(`_NPflow_FmeasureC`, pred, ref)
}

#' C++ implementation of the F-measure computation without the reference class 0
#'
#' Aghaeepour in FlowCAP 1 ignore the reference class labeled "0"
#'
#'@param pred vector of a predicted partition
#'@param ref vector of a reference partition
#'
#'@references N Aghaeepour, G Finak, H Hoos, TR Mosmann, RR Brinkman, R Gottardo,
#'RH Scheuermann, Critical assessment of automated flow cytometry data analysis
#'techniques, \emph{Nature Methods}, 10(3):228-38, 2013.
#'
#'@export
#'
#'@examples
#'library(NPflow)
#'pred <- c(1,1,2,3,2,3)
#'ref <- c(2,2,0,0,0,3)
#'FmeasureC(pred, ref)
#'FmeasureC_no0(pred, ref)
#'
FmeasureC_no0 <- function(pred, ref) {
    .Call(`_NPflow_FmeasureC_no0`, pred, ref)
}

#' Multiple cost computations with the F-measure as the loss function
#'
#'C++ implementation of multiple cost computations with the F-measure as the loss
#'function using the Armadillo library
#'
#'@param c a matrix where each column is one MCMC partition
#'
#'@return a list with the following elements:
#'  \item{\code{Fmeas:}}{ TODO}
#'  \item{\code{cost:}}{ TODO}
#'@export
#'
#'@examples
#'library(NPflow)
#'c <- list(c(1,1,2,3,2,3), c(1,1,1,2,3,3),c(2,2,1,1,1,1))
#'#Fmeasure_costC(sapply(c, "["))
#'
#'if(interactive()){
#' c2 <- list()
#' for(i in 1:100){
#'     c2 <- c(c2, list(rmultinom(n=1, size=2000, prob=rexp(n=2000))))
#' }
#' Fmeasure_costC(sapply(c2, "["))
#'}
#'
Fmeasure_costC <- function(c) {
    .Call(`_NPflow_Fmeasure_costC`, c)
}

#' C++ implementation of similarity matrix computation using pre-computed distances
#'
#'
#'@param c an MCMC partitions of length \code{n}.
#'
#'@param d a symmetric \code{n x n} matrix containing distances
#'between each group distributions.
#'
#'@author Boris Hejblum, Chariff Alkhassim
#'
#'@export
#'
#'@examples
#'c <- c(1,1,2,3,2,3)
#'d <- matrix(runif(length(c)^2),length(c))
#'NuMatParC(c,d)
#'
#'
NuMatParC <- function(c, d) {
    .Call(`_NPflow_NuMatParC`, c, d)
}

#' C++ implementation of residual trace computation step used when sampling the scale
#'
#'@param eps a numeric matrix where each column contains the centered and unskewed observations
#'@param sigma a numeric covariance matrix
#'
#'@return the computed trace
#'
#'@keywords internal
#'
#'@export
#'
traceEpsC <- function(eps, sigma) {
    .Call(`_NPflow_traceEpsC`, eps, sigma)
}

#' C++ implementation of multivariate Normal inverse Wishart probability density function for multiple inputs
#'
#'@param Mu data matrix of dimension \code{p x n}, \code{p} being the dimension of the
#'data and n the number of data points, where each column is an observed mean vector.
#'@param Sigma list of length \code{n} of observed variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param U_Mu0 mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
#'distributions for which the density probability has to be evaluated
#'@param U_Sigma0 list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param U_Kappa0 vector of length \code{K} of scale parameters.
#'@param U_Nu0 vector of length \code{K} of degree of freedom parameters.
#'@param Log logical flag for returning the log of the probability density
#'function. Defaults is \code{TRUE}.
#'@return matrix of densities of dimension K x n
#'
#'@references Hejblum BP, Alkhassim C, Gottardo R, Caron F and Thiebaut R (2019) 
#'Sequential Dirichlet Process Mixtures of Multivariate Skew t-distributions for 
#'Model-based Clustering of Flow Cytometry Data. The Annals of Applied Statistics, 
#'13(1): 638-660. <doi: 10.1214/18-AOAS1209>. <arXiv: 1702.04407>. 
#'\url{https://arxiv.org/abs/1702.04407} \doi{10.1214/18-AOAS1209}
#'
#'@export
#'
#'
mmNiWpdfC <- function(Mu, Sigma, U_Mu0, U_Kappa0, U_Nu0, U_Sigma0, Log = TRUE) {
    .Call(`_NPflow_mmNiWpdfC`, Mu, Sigma, U_Mu0, U_Kappa0, U_Nu0, U_Sigma0, Log)
}

#' C++ implementation of multivariate structured Normal inverse Wishart probability density function for multiple inputs
#'
#'@param xi data matrix of dimensions \code{p x n} where columns contain the observed
#'mean vectors.
#'@param psi data matrix of dimensions \code{p x n} where columns contain the observed
#'skew parameter vectors.
#'@param Sigma list of length \code{n} of observed variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param U_xi0 mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
#'distributions for which the density probability has to be evaluated.
#'@param U_psi0 skew parameter vectors matrix of dimension \code{p x K}.
#'@param U_B0 list of length \code{K} of structured scale matrices,
#'each of dimensions \code{p x p}.
#'@param U_Sigma0 list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param U_df0 vector of length \code{K} of degree of freedom parameters.
#'@param Log logical flag for returning the log of the probability density
#'function. Defaults is \code{TRUE}.
#'@return matrix of densities of dimension \code{K x n}
#'
#'@references Hejblum BP, Alkhassim C, Gottardo R, Caron F and Thiebaut R (2019) 
#'Sequential Dirichlet Process Mixtures of Multivariate Skew t-distributions for 
#'Model-based Clustering of Flow Cytometry Data. The Annals of Applied Statistics, 
#'13(1): 638-660. <doi: 10.1214/18-AOAS1209>. <arXiv: 1702.04407>. 
#'\url{https://arxiv.org/abs/1702.04407} \doi{10.1214/18-AOAS1209}
#'
#'@export
#'
mmsNiWpdfC <- function(xi, psi, Sigma, U_xi0, U_psi0, U_B0, U_Sigma0, U_df0, Log = TRUE) {
    .Call(`_NPflow_mmsNiWpdfC`, xi, psi, Sigma, U_xi0, U_psi0, U_B0, U_Sigma0, U_df0, Log)
}

#' C++ implementation of multivariate Normal probability density function for multiple inputs
#'
#'@param x data matrix of dimension \code{p x n}, \code{p} being the dimension of the
#'data and n the number of data points.
#'@param mean mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
#'distributions for which the density probability has to be evaluated.
#'@param varcovM list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param Log logical flag for returning the log of the probability density
#'function. Defaults is \code{TRUE}.
#'@return matrix of densities of dimension \code{K x n}.
#'@export
#'@examples
#'if(require(microbenchmark)){
#'library(microbenchmark)
#' microbenchmark(mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE),
#'                mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE),
#'                mmvnpdfC(x=matrix(1.96), mean=matrix(0), varcovM=list(diag(1)), Log=FALSE),
#'                times=1000L)
#' microbenchmark(mvnpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1), mean=c(-0.2, 0.3),
#'                       varcovM=matrix(c(2, 0.2, 0.2, 2), ncol=2), Log=FALSE),
#'                mvnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1), mean=c(-0.2, 0.3),
#'                        varcovM=matrix(c(2, 0.2, 0.2, 2), ncol=2), Log=FALSE),
#'                mmvnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'                         mean=matrix(c(-0.2, 0.3), nrow=2, ncol=1),
#'                         varcovM=list(matrix(c(2, 0.2, 0.2, 2), ncol=2)), Log=FALSE),
#'                times=1000L)
#' microbenchmark(mvnpdf(x=matrix(c(rep(1.96,2),rep(0,2)), nrow=2, ncol=2),
#'                       mean=list(c(0,0),c(-1,-1), c(1.5,1.5)),
#'                       varcovM=list(diag(2),10*diag(2), 20*diag(2)), Log=FALSE),
#'                mmvnpdfC(matrix(c(rep(1.96,2),rep(0,2)), nrow=2, ncol=2),
#'                         mean=matrix(c(0,0,-1,-1, 1.5,1.5), nrow=2, ncol=3),
#'                         varcovM=list(diag(2),10*diag(2), 20*diag(2)), Log=FALSE),
#'                times=1000L)
#'}else{
#' cat("package 'microbenchmark' not available\n")
#'}
mmvnpdfC <- function(x, mean, varcovM, Log = TRUE) {
    .Call(`_NPflow_mmvnpdfC`, x, mean, varcovM, Log)
}

#' C++ implementation of multivariate skew Normal probability density function for multiple inputs
#'
#'@param x data matrix of dimension \code{p x n}, \code{p} being the dimension of the
#'data and n the number of data points.
#'@param xi mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
#'distributions for which the density probability has to be evaluated.
#'@param psi skew parameter vectors matrix of dimension \code{p x K}.
#'@param sigma list of length K of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param Log logical flag for returning the log of the probability density
#'function. Default is \code{TRUE}.
#'@return matrix of densities of dimension \code{K x n}.
#'
#'@author Boris Hejblum
#'
#'@export
#'@examples
#'mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'          xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2)), Log=FALSE
#'          )
#'mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'          xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2))
#'          )
#'
#'if(require(microbenchmark)){
#' library(microbenchmark)
#' microbenchmark(mvsnpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1), xi=c(0, 0), psi=c(1, 1),
#'                        sigma=diag(2), Log=FALSE),
#'                mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1), xi=matrix(c(0, 0)),
#'                          psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2)), Log=FALSE),
#'                times=1000L
#'              )
#' microbenchmark(mvsnpdf(x=matrix(c(rep(1.96,2),rep(0,2)), nrow=2, ncol=2),
#'                       xi=list(c(0,0),c(-1,-1), c(1.5,1.5)),
#'                       psi=list(c(0.1,0.1),c(-0.1,-1), c(0.5,-1.5)),
#'                       sigma=list(diag(2),10*diag(2), 20*diag(2)), Log=FALSE),
#'                mmvsnpdfC(matrix(c(rep(1.96,2),rep(0,2)), nrow=2, ncol=2),
#'                          xi=matrix(c(0,0,-1,-1, 1.5,1.5), nrow=2, ncol=3),
#'                          psi=matrix(c(0.1,0.1,-0.1,-1, 0.5,-1.5), nrow=2, ncol=3),
#'                          sigma=list(diag(2),10*diag(2), 20*diag(2)), Log=FALSE),
#'               times=1000L)
#'}else{
#' cat("package 'microbenchmark' not available\n")
#'}
mmvsnpdfC <- function(x, xi, psi, sigma, Log = TRUE) {
    .Call(`_NPflow_mmvsnpdfC`, x, xi, psi, sigma, Log)
}

#' C++ implementation of multivariate Normal probability density function for multiple inputs
#'
#'@param x data matrix of dimension \code{p x n}, \code{p} being the dimension of the
#'data and n the number of data points.
#'@param xi mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
#'distributions for which the density probability has to be evaluated.
#'@param psi skew parameter vectors matrix of dimension \code{p x K}.
#'@param sigma list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param df vector of length K of degree of freedom parameters.
#'@param Log logical flag for returning the log of the probability density
#'function. Defaults is \code{TRUE}.
#'@return matrix of densities of dimension \code{K x n}.
#'
#'@author Boris Hejblum
#'
#'@export
#'@examples
#'mmvstpdfC(x = matrix(c(3.399890,-5.936962), ncol=1), xi=matrix(c(0.2528859,-2.4234067)),
#'psi=matrix(c(11.20536,-12.51052), ncol=1),
#'sigma=list(matrix(c(0.2134011, -0.0382573, -0.0382573, 0.2660086), ncol=2)),
#'df=c(7.784106)
#')
#'mvstpdf(x = matrix(c(3.399890,-5.936962), ncol=1), xi=c(0.2528859,-2.4234067),
#'psi=c(11.20536,-12.51052),
#'sigma=matrix(c(0.2134011, -0.0382573, -0.0382573, 0.2660086), ncol=2),
#'df=c(7.784106)
#')
#'
#'#skew-normal limit
#'mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'          xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2))
#'          )
#'mvstpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'        xi=c(0, 0), psi=c(1, 1), sigma=diag(2),
#'        df=100000000
#'        )
#'mmvstpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'          xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2)),
#'          df=100000000
#'          )
#'
#'#non-skewed limit
#'mmvtpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'         mean=matrix(c(0, 0)), varcovM=list(diag(2)),
#'         df=10
#'         )
#'mmvstpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'          xi=matrix(c(0, 0)), psi=matrix(c(0, 0),ncol=1), sigma=list(diag(2)),
#'          df=10
#'          )
#'
#'if(require(microbenchmark)){
#' library(microbenchmark)
#' microbenchmark(mvstpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'                        xi=c(0, 0), psi=c(1, 1),
#'                        sigma=diag(2), df=10),
#'                mmvstpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
#'                          xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1),
#'                          sigma=list(diag(2)), df=10),
#'                times=1000L)
#'}else{
#' cat("package 'microbenchmark' not available\n")
#'}
mmvstpdfC <- function(x, xi, psi, sigma, df, Log = TRUE) {
    .Call(`_NPflow_mmvstpdfC`, x, xi, psi, sigma, df, Log)
}

#' C++ implementation of multivariate Normal probability density function for multiple inputs
#'
#'@param x data matrix of dimension \code{p x n}, \code{p} being the dimension of the
#'data and n the number of data points.
#'@param mean mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
#'distributions for which the density probability has to be evaluated.
#'@param varcovM list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param df vector of length \code{K} of degree of freedom parameters.
#'@param Log logical flag for returning the log of the probability density
#'function. Defaults is \code{TRUE}.
#'@return matrix of densities of dimension \code{K x n}.
#'
#'@author Boris Hejblum
#'
#'@export
#'@examples
#'mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE)
#'mvtpdf(x=matrix(1.96), mean=0, varcovM=diag(1), df=10000000, Log=FALSE)
#'mmvtpdfC(x=matrix(1.96), mean=matrix(0), varcovM=list(diag(1)), df=10000000, Log=FALSE)
#'
#'mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1))
#'mvtpdf(x=matrix(1.96), mean=0, varcovM=diag(1), df=10000000)
#'mmvtpdfC(x=matrix(1.96), mean=matrix(0), varcovM=list(diag(1)), df=10000000)
#'
#'mvtpdf(x=matrix(1.96), mean=0, varcovM=diag(1), df=10)
#'mmvtpdfC(x=matrix(1.96), mean=matrix(0), varcovM=list(diag(1)), df=10)
#'
#'
#'if(require(microbenchmark)){
#' library(microbenchmark)
#' microbenchmark(mvtpdf(x=matrix(1.96), mean=0, varcovM=diag(1), df=1, Log=FALSE),
#'                mmvtpdfC(x=matrix(1.96), mean=matrix(0), varcovM=list(diag(1)),
#'                         df=c(1), Log=FALSE),
#'                times=10000L)
#'}else{
#' cat("package 'microbenchmark' not available\n")
#'}
mmvtpdfC <- function(x, mean, varcovM, df, Log = TRUE) {
    .Call(`_NPflow_mmvtpdfC`, x, mean, varcovM, df, Log)
}

#' C++ implementation of multivariate Normal probability density function for multiple inputs
#'
#'@param x data matrix of dimension p x n, p being the dimension of the
#'data and n the number of data points
#'@param c integer vector of cluster allocations with values from 1 to K
#'@param clustval vector of unique values from c in the order corresponding to
#'the storage of cluster parameters in \code{xi}, \code{psi}, and \code{varcovM}
#'@param mu mean vectors matrix of dimension p x K, K being the number of
#'clusters
#'@param sigma list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param loglik logical flag or returning the log-likelihood instead of the likelihood.
#'Default is \code{TRUE}.
#'@return a list:
#'\item{\code{"indiv"}:}{ vector of likelihood of length n;}
#'\item{\code{"clust"}:}{ vector of likelihood of length K;}
#'\item{\code{"total"}:}{ total (log)-likelihood;}
#'
#'@author Boris Hejblum
#'
mvnlikC <- function(x, c, clustval, mu, sigma, loglik = TRUE) {
    .Call(`_NPflow_mvnlikC`, x, c, clustval, mu, sigma, loglik)
}

#' C++ implementation of multivariate normal probability density function for 
#' multiple inputs
#'
#'Based on the implementation from Nino Hardt and Dicko Ahmadou
#'\url{https://gallery.rcpp.org/articles/dmvnorm_arma/}
#'(accessed in August 2014)
#'
#'@param x data matrix
#'@param mean mean vector
#'@param varcovM variance covariance matrix
#'@param Log logical flag for returning the log of the probability density
#'function. Default is \code{TRUE}
#'@return vector of densities
#'
#'@author Boris P. Hejblum
#'
#'@export
#'
#'@examples
#'mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE)
#'mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE)
#'mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1))
#'mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1))
#'
#'if(require(microbenchmark)){
#' library(microbenchmark)
#' microbenchmark(dnorm(1.96),
#'                mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE),
#'                mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE),
#'                times=10000L)
#'}else{
#' cat("package 'microbenchmark' not available\n")
#'}
#'
mvnpdfC <- function(x, mean, varcovM, Log = TRUE) {
    .Call(`_NPflow_mvnpdfC`, x, mean, varcovM, Log)
}

#' C++ implementation of multivariate skew normal likelihood function for multiple inputs
#'
#'@param x data matrix of dimension p x n, p being the dimension of the
#'data and n the number of data points
#'@param c integer vector of cluster allocations with values from 1 to K
#'@param clustval vector of unique values from c in the order corresponding to
#'the storage of cluster parameters in \code{xi}, \code{psi}, and \code{sigma}
#'@param xi mean vectors matrix of dimension p x K, K being the number of
#'clusters
#'@param psi skew parameter vectors matrix of dimension \code{p x K}
#'@param sigma list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param loglik logical flag or returning the log-likelihood instead of the likelihood.
#'Default is \code{TRUE}.
#'@return a list:
#'\item{\code{"indiv"}:}{ vector of likelihood of length n;}
#'\item{\code{"clust"}:}{ vector of likelihood of length K;}
#'\item{\code{"total"}:}{ total (log)-likelihood;}
#'
#'@author Boris Hejblum
#'
mvsnlikC <- function(x, c, clustval, xi, psi, sigma, loglik = TRUE) {
    .Call(`_NPflow_mvsnlikC`, x, c, clustval, xi, psi, sigma, loglik)
}

#' C++ implementation of multivariate skew t likelihood function for multiple inputs
#'
#'@param x data matrix of dimension p x n, p being the dimension of the
#'data and n the number of data points
#'@param c integer vector of cluster allocations with values from 1 to K
#'@param clustval vector of unique values from c in the order corresponding to
#'the storage of cluster parameters in \code{xi}, \code{psi}, and \code{sigma}
#'@param xi mean vectors matrix of dimension p x K, K being the number of
#'clusters
#'@param psi skew parameter vectors matrix of dimension \code{p x K}
#'@param sigma list of length \code{K} of variance-covariance matrices,
#'each of dimensions \code{p x p}.
#'@param df vector of length \code{K} of degree of freedom parameters.
#'@param loglik logical flag or returning the log-likelihood instead of the likelihood.
#'Default is \code{TRUE}.
#'@return a list:
#'\item{\code{"indiv"}:}{ vector of likelihood of length n;}
#'\item{\code{"clust"}:}{ vector of likelihood of length K;}
#'\item{\code{"total"}:}{ total (log)-likelihood;}
#'
#'@author Boris Hejblum
#'
mvstlikC <- function(x, c, clustval, xi, psi, sigma, df, loglik = TRUE) {
    .Call(`_NPflow_mvstlikC`, x, c, clustval, xi, psi, sigma, df, loglik)
}

#' C++ implementation of the multinomial sampling from a matrix
#' of column vectors, each containing the sampling probabilities
#' for their respective draw
#'
#'@param probMat a numeric matrix of dim \code{k x n} of containing column vectors of sampling
#'probabilities for each class \code{k}.
#'
#'@param Log a logical flag indicating whether the provided \code{probMat} is on the log scale
#'or natural probability scale. Default is \code{FALSE} in which case it is considered on the natural
#'probability scale.
#'
#'@return a vector of integer of length \code{n} containing the multinomial draws for each
#'observation, i.e. the class allocation.
#'
#'@keywords internal
#'
#'@export
#'
sampleClassC <- function(probMat, Log = FALSE) {
    .Call(`_NPflow_sampleClassC`, probMat, Log)
}

#' C++ implementation
#'
#'
#'@param cc a matrix whose columns each represents a (MCMC) partition
#'
#'@export
#'
#'@examples
#'c <- list(c(1,1,2,3,2,3), c(1,1,1,2,3,3),c(2,2,1,1,1,1))
#'similarityMatC(sapply(c, "["))
#'
#'c2 <- list()
#'for(i in 1:10){
#'     c2 <- c(c2, list(rmultinom(n=1, size=200, prob=rexp(n=200))))
#'}
#'similarityMatC(sapply(c2, "["))
#'
similarityMatC <- function(cc) {
    .Call(`_NPflow_similarityMatC`, cc)
}

#' C++ implementation
#'
#'
#'@param cc a matrix whose columns each represents a ()MCMC) partition
#'
#'@export
#'
#'@examples
#'c <- list(c(1,1,2,3,2,3), c(1,1,1,2,3,3),c(2,2,1,1,1,1))
#'similarityMat_nocostC(sapply(c, "["))
#'
#'c2 <- list()
#'for(i in 1:10){
#'     c2 <- c(c2, list(rmultinom(n=1, size=1000, prob=rexp(n=1000))))
#'}
#'
#'c3 <- sapply(c2, "[")
#'
#'if(require(microbenchmark)){
#' library(microbenchmark)
#' microbenchmark(similarityMat(c3), similarityMat_nocostC(c3), times=2L)
#'}else{
#' cat("package 'microbenchmark' not available\n")
#'}
similarityMat_nocostC <- function(cc) {
    .Call(`_NPflow_similarityMat_nocostC`, cc)
}

#' C++ implementation
#'
#'
#'@param c is an MCMC partition
#'
#'@author Chariff Alkhassim
#'
#'@export
#'
#'@examples
#'cc <- c(1,1,2,3,2,3)
#'vclust2mcoclustC(cc)
#'
#'
vclust2mcoclustC <- function(c) {
    .Call(`_NPflow_vclust2mcoclustC`, c)
}

