% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{EndometrialCancer_df}
\alias{EndometrialCancer_df}
\title{Histology Grade and Risk Factors for Endometrial Cancer}
\format{
A data frame with 79 observations and 4 variables:
\describe{
  \item{NV}{Nuclear volume (integer).}
  \item{PI}{Pathological index (integer).}
  \item{EH}{Endometrial hyperplasia (numeric).}
  \item{HG}{Histology grade (integer).}
}
}
\source{
Data taken from the enrichwith package.
The dataset was first analyzed in Heinze and Schemper (2002) and originally provided by Dr. E. Asseryanis from the Medical University of Vienna.
The data was downloaded in .dat format from \url{https://users.stat.ufl.edu/~aa/glm/data/}, which provides datasets used in Agresti (2015).
}
\usage{
data(EndometrialCancer_df)
}
\description{
This dataset, EndometrialCancer_df, is a data frame containing information on histology grades and associated risk factors for 79 cases of endometrial cancer.
The dataset provides variables related to histological grades, pathological indices, and other clinical measures.
The dataset consists of 79 observations with 4 variables.
}
\details{
The dataset name has been kept as 'EndometrialCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
