% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ostats_plot.R
\name{Ostats_plot}
\alias{Ostats_plot}
\title{Plot community trait overlap}
\usage{
Ostats_plot(
  plots,
  sp,
  traits,
  overlap_dat = NULL,
  use_plots = NULL,
  n_col = 1,
  scale = "fixed",
  colorvalues = NULL,
  alpha = 0.5,
  adjust = 2,
  bin_width = 1,
  limits_x = NULL,
  legend = FALSE,
  name_x = "trait value",
  name_y = "probability density",
  normalize = TRUE,
  means = FALSE,
  circular = FALSE,
  discrete = FALSE,
  circular_args = list()
)
}
\arguments{
\item{plots}{Site identity: a vector of names of each community.}

\item{sp}{Taxon identity: a vector of species or taxa names.}

\item{traits}{A vector of trait measurements for each individual, or a matrix
or data frame with rows representing individuals and columns representing traits.}

\item{overlap_dat}{Optional: an object containing the output of \code{\link{Ostats}}.
If provided, overlap statistics will be displayed in the plot panels.}

\item{use_plots}{a vector of sites to plot. If NULL, the function will plot all the sites.}

\item{n_col}{Number of columns for layout of individual panels. Default is 1.}

\item{scale}{If you want the scale of x, y or both x and y axis to be independent,
set the argument to "free_x", "free_y" or "free" respectively.
Default = "fixed" which uses the same scale across all sites.
See \code{\link[ggplot2]{facet_grid}}.}

\item{colorvalues}{Vector of color values for the density polygons.
Defaults to a viridis palette if none provided.}

\item{alpha}{defines the transparency level for the density polygons. Default is 0.5.}

\item{adjust}{the bandwidth adjustment of the density polygons. Default is 2.
See \code{\link[stats]{density}}. Only used if \code{discrete = FALSE}.}

\item{bin_width}{the width of each bin of the histograms. Default is 1.
Only used if \code{discrete = TRUE}.}

\item{limits_x}{Vector of length 2, with multiplicative factor to apply to the minimum
and maximum values of each trait to expand the limits of the x axis.
Default is \code{c(0.5, 1.5)}, or 0.5 times the minimum and 1.5 times the maximum
value of each trait, for continuous traits. For discrete traits the default is
\code{c(1, 1)} or no expansion of limits.}

\item{legend}{Whether to include a legend. Defaults to \code{FALSE}.}

\item{name_x}{x-axis label. Default is 'trait value'}

\item{name_y}{y-axis label. Default is 'probability density'}

\item{normalize}{if \code{TRUE}, areas of density plots are normalized to be equal
across taxa; if \code{FALSE}, areas will be proportional to abundance.
Default is \code{TRUE}.}

\item{means}{if \code{TRUE}, trait means for each species are plotted in an additional plot
column next to the traits distribution plots for each site. Default is \code{FALSE}.}

\item{circular}{if \code{TRUE}, plots density plots or histograms using polar
coordinates, and estimates density using method for objects of class
\code{circular}. Default is \code{FALSE}.}

\item{discrete}{if \code{TRUE}, plots histograms at discrete trait values instead
of smooth kernel density plots. Default is \code{FALSE}.}

\item{circular_args}{optional list of additional arguments to pass to
\code{\link[circular]{circular}}. Only used if \code{circular = TRUE} and
\code{discrete = FALSE}. If no arguments are provided, default arguments to
\code{\link[circular]{circular}} are used.}
}
\value{
Density plots of species trait distributions plotted together
 for each community to show how they overlap each other. Each community
 is plotted on a separate panel within a multipanel figure.
 The overlap value obtained as output from \code{\link{Ostats}}
 is labelled on each community graph, if provided by the user.

 If trait values are discrete rather than continuous, histograms are
 plotted instead of kernel density plots.

 If trait values are circular, a circular kernel density estimate for
 each species is plotted on a polar coordinate plot. If trait values are
 both circular and discrete, a "sunburst" plot is returned.

 The class of the returned object is \code{Ostats_plot_object}. Calling
 \code{print} on this object will draw the plot using
 \code{\link[grid]{grid.draw}}.

 If more than one trait is provided, a list of objects of class
 \code{Ostats_plot_object} will be returned.
}
\description{
This function plots the overlap of traits among
 species for each community. If there are multiple traits,
 each trait is plotted separately in one-dimensional space.
}
\examples{
# set the arguments:
plots <- small_mammal_data$siteID
sp <- small_mammal_data$taxonID
traits <- log10(small_mammal_data$weight)

# to plot only selected sites:
use_plots <- c('BART','KONZ','JORN')


Ostats_plot(plots = plots, sp = sp, traits = traits,
           overlap_dat = small_mammal_Ostats,
           use_plots = use_plots, means = TRUE)
}
\seealso{
\code{\link{Ostats}} to Calculate O-statistics (community-level
 pairwise niche overlap statistics)
}
