% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigs2mat.R
\name{sigs2mat}
\alias{sigs2mat}
\title{Utility function for PCGII inference results}
\usage{
sigs2mat(sigs, P)
}
\arguments{
\item{sigs}{A dataframe of locations (row, col) of selected edges.}

\item{P}{A number, the number of nodes in the network.}
}
\value{
A matrix of size P*(P-1)/2, with 0, 1.
}
\description{
A utility function takes PCGII inference results as input and generates an adjacency matrix corresponding to the significant partial correlations
}
\examples{
edges=cbind.data.frame(row=c(1,2,3,1,6,2,1,6,1,4),
                       col=c(2,1,1,3,2,6,6,1,4,1)) # five edges
sigs2mat(sigs = edges, P = 6)
}
