% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultest.pe.cauchy.R
\name{simultest.pe.cauchy}
\alias{simultest.pe.cauchy}
\title{Two-sample PE simultaneous test using Cauchy combination}
\usage{
simultest.pe.cauchy(dataX,dataY,delta_mean=NULL,delta_cov=NULL)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}

\item{delta_mean}{a scalar; the thresholding value used in the construction of
the PE component for mean test; see \code{\link{meantest.pe.comp}} for details.}

\item{delta_cov}{a scalar; the thresholding value used in the construction of
the PE component for covariance test; see \code{\link{covtest.pe.comp}} for details.}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample PE simultaneous test on high-dimensional
mean vectors and covariance matrices using Cauchy combination.
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}.
Let \eqn{M_{PE}} and \eqn{T_{PE}} denote
the PE mean test statistic and PE covariance test statistic, respectively.
(see \code{\link{meantest.pe.comp}}
and \code{\link{covtest.pe.comp}} for details).
Let \eqn{p_{m}} and \eqn{p_{c}} denote their respective \eqn{p}-values.
The PE simultaneous test statistic via Cauchy combination is defined as
\deqn{C_{PE} = \frac{1}{2}\tan((0.5-p_{m})\pi) + \frac{1}{2}\tan((0.5-p_{c})\pi).}
It has been proved that with some regularity conditions, under the null hypothesis
\eqn{H_0: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2 \ \text{ and }
\ \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the two tests are asymptotically independent as \eqn{n_1, n_2, p\rightarrow \infty},
and therefore \eqn{C_{PE}} asymptotically converges in distribution to
a standard Cauchy distribution.
The asymptotic \eqn{p}-value is obtained by
\deqn{p\text{-value} = 1-F_{Cauchy}(C_{PE}),}
where \eqn{F_{Cauchy}(\cdot)} is the cdf of the standard Cauchy distribution.
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
simultest.pe.cauchy(X,Y)
}
\references{
Yu, X., Li, D., Xue, L., and Li, R. (2022). Power-enhanced simultaneous test
of high-dimensional mean vectors and covariance matrices with application
to gene-set testing. \emph{Journal of the American Statistical Association},
(in press):1–14.
}
