% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PJFM_wrapper.R
\name{PJFM_fit}
\alias{PJFM_fit}
\title{The function to fit PJFM.}
\usage{
PJFM_fit(
  RecurData = NULL,
  SurvData = NULL,
  control_list = NULL,
  EventName = NULL,
  nlam = 50,
  ridge = 0,
  pmax = 10,
  min_ratio = 0.01,
  maxiter = 100,
  eps = 1e-04
)
}
\arguments{
\item{RecurData}{a data frame containing the recurrent events data
(see \code{\link{RecurData}}).}

\item{SurvData}{a data frame containing the survival data
(see \code{\link{SurvData}}).}

\item{control_list}{a list of parameters specifying the joint frailty model
(see \code{\link{control_list}}).}

\item{EventName}{a vector indicating which set of recurrent events
to be analyzed. If NULL, all recurrent events in RecurData will be used.}

\item{nlam}{number of tuning parameters.}

\item{ridge}{ridge penalty.}

\item{pmax}{the maximum of biomarkers being selected.
The algorithm will stop early if the maximum has been reached.}

\item{min_ratio}{the ratio between the largest possible penalty
and the smallest penalty to tune.}

\item{maxiter}{the maximum number of iterations.}

\item{eps}{threshold for convergence.}
}
\value{
return a list with the following objects.
\item{object_name}{indicates whether this is a PJFM or JFM object. If JFM object, then some
recurrent events were selected and the returned model is the refitted model with
only selected recurrent events, but no penalty; otherwise, PJFM object is returned.}
\item{fit}{fitted models with estimated parameters in both submodels.}
\item{hess}{Hessian matrix; only available for JFM object.}
}
\description{
The function is used to fit PJFM.
}
\examples{

require(splines)
data(PJFMdata)

up_limit = ceiling(max(SurvData$ftime))
bs_fun <- function(t=NULL){
    bs(t, knots = NULL, degree = 2, intercept = TRUE, Boundary.knots= c(0,up_limit))
}

recur_fix_time_fun = bs_fun
recur_ran_time_fun <- function(x=NULL){
    xx = cbind(1, matrix(x, ncol = 1))
    colnames(xx) = c("intercept","year_1")
    xx[,1,drop=FALSE]
    #xx
}

surv_fix_time_fun = bs_fun

control_list = list(
    ID_name = "ID", item_name = "feature_id",
    time_name = "time", fix_cov = "x", random_cov = NULL,
    recur_fix_time_fun = recur_fix_time_fun,
    recur_ran_time_fun = recur_ran_time_fun,
    surv_fix_time_fun = surv_fix_time_fun,
    surv_time_name = "ftime",  surv_status_name = "fstat",
    surv_cov = "x", n_points = 5
)

\donttest{
## this step takes about a few minute.
## analyze the first 10 recurrent events
res = PJFM_fit(RecurData=RecurData, SurvData=SurvData,
               control_list=control_list, EventName=1:10)

## get summary table
summary_table = PJFM_summary(res)

}

}
\references{
Jiehuan Sun. "Dynamic Prediction with Penalized Joint Frailty Model of High-Dimensional Recurrent Event Data and a Survival Outcome".
}
