% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.R
\name{cov_holder}
\alias{cov_holder}
\title{Calculate the covariance for two time points with sparse sampling}
\usage{
cov_holder(sparse_pk)
}
\arguments{
\item{sparse_pk}{A sparse_pk object from \code{\link[=as_sparse_pk]{as_sparse_pk()}}}
}
\value{
A matrix with one row and one column for each element of
\code{sparse_pk_attribute}.  The covariances are on the off diagonals, and for
simplicity of use, it also calculates the variance on the diagonal
elements.
}
\description{
The calculation follows equation A3 in Holder 2001 (see references below):
}
\details{
\deqn{\hat{\sigma}_{ij} = \sum\limits_{k=1}^{r_{ij}}{\frac{\left(x_{ik} - \bar{x}_i\right)\left(x_{jk} - \bar{x}_j\right)}{\left(r_{ij} - 1\right) + \left(1 - \frac{r_{ij}}{r_i}\right)\left(1 - \frac{r_{ij}}{r_j}\right)}}}{sigma_ij = sum_(k=1)^(r_ij)((x_ik-xbar_i)(x_jk-xbar_j)/((r_ij-1)+(1-r_ij/r_i)*(1-r_ij/r_j)))}

If \eqn{r_{ij} = 0}{r_ij = 0}, then \eqn{\hat{\sigma}_{ij}}{sigma_ij} is
defined as zero (rather than dividing by zero).

Where:
\describe{
\item{\eqn{\hat{\sigma}_{ij}}{sigma_ij}}{The covariance of times i and j}
\item{\eqn{r_i}{r_i} and \eqn{r_j}{r_j}}{The number of subjects (usually animals) at times i and j, respectively}
\item{\eqn{r_{ij}{r_ij}}}{The number of subjects (usually animals) at both times i and j}
\item{\eqn{x_{ik}}{x_ik} and \eqn{x_{jk}}{x_jk}}{The concentration measured for animal k at times i and j, respectively}
\item{\eqn{\bar{x}_i}{xbar_i} and \eqn{\bar{x}_j}{xbar_j}}{The mean of the concentrations at times i and j, respectively}
}

The Cauchy-Schwartz inequality is enforced for covariances to keep
correlation coefficients between -1 and 1, inclusive, as described in
equations 8 and 9 of Nedelman and Jia 1998.
}
\references{
Holder DJ. Comments on Nedelman and Jia’s Extension of Satterthwaite’s
Approximation Applied to Pharmacokinetics. Journal of Biopharmaceutical
Statistics. 2001;11(1-2):75-79. doi:10.1081/BIP-100104199

Nedelman JR, Jia X. An extension of Satterthwaite’s approximation applied to
pharmacokinetics. Journal of Biopharmaceutical Statistics. 1998;8(2):317-328.
doi:10.1080/10543409808835241
}
\keyword{Internal}
