% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evm.R
\name{spi}
\alias{spi}
\title{Schedule Performance Index (SPI).}
\usage{
spi(ev, pv)
}
\arguments{
\item{ev}{Earned Value.}

\item{pv}{Planned Value.}
}
\value{
The function returns the Schedule Performance Index (SPI) of work completed.
}
\description{
Schedule Performance Index (SPI).
}
\examples{
# Set the BAC, schedule, and current time period for an example project.
bac <- 100000
schedule <- c(0.1, 0.2, 0.4, 0.7, 1.0)
time_period <- 3

# Calculate the PV.
pv <- pv(bac, schedule, time_period)

# Set the actual \% complete and calculate the EV.
actual_per_complete <- 0.35
ev <- ev(bac, actual_per_complete)

# Calculate the SPI and print the results.
spi <- spi(ev, pv)
cat("Schedule Performance Index (SPI):", spi, "\n")
}
