% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFM.fit.models.R
\name{SFM.fit.models}
\alias{SFM.fit.models}
\title{Compare SFM estimated using robust estimators with that estimated by OLS}
\usage{
SFM.fit.models(
  Ra,
  Rb,
  Rf = 0,
  family = "mopt",
  which.plots = NULL,
  plots = TRUE
)
}
\arguments{
\item{Ra}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{Rb}{return vector of the benchmark asset}

\item{Rf}{risk free rate, in same period as your returns}

\item{family}{(Optional): 
If method == "Robust": 
  This is a string specifying the name of the family of loss function
  to be used (current valid options are "bisquare", "opt" and "mopt").
  Incomplete entries will be matched to the current valid options. 
  Defaults to "mopt".
Else: the parameter is ignored}

\item{which.plots}{specify the plot numbers that you want to see. Default
option is that program will ask you to choose a plot}

\item{plots}{Boolean to output plots after the function. Defaults to TRUE}
}
\description{
This function provies a simple plug and play option for user to compare the
SFM estimates by lm and lmrobdetMM functions, using the fit.models framework.
This will allow for an easier comparison using charts and tables
}
\examples{
\dontrun{
# First we load the data
    data(managers)
    mgrs <- managers["2002/"]  # So that all have managers have complete history
    names(mgrs)[7:10] <- c("LSEQ","SP500","Bond10Yr","RF") # Short names for last 3
    
    # NOTE: Use plots=TRUE to be able to see plots

    fitModels <- SFM.fit.models(mgrs$HAM1,mgrs$SP500,Rf = mgrs$RF, plots=FALSE)
    coef(fitModels)
    summary(fitModels)
    class(fitModels)
    
    SFM.fit.models(mgrs$HAM1, mgrs$SP500, Rf = mgrs$RF, plots=FALSE)
    
    SFM.fit.models(mgrs[,6], mgrs[,8], Rf=.035/12, plots=FALSE) 
    
    SFM.fit.models(mgrs$HAM6, mgrs$SP500, Rf=.035/12, family = "mopt", 
                   which.plots = c(1,2), plots=FALSE) 
		 
		 SFM.fit.models(mgrs$HAM2, mgrs$SP500, Rf = mgrs$RF, family = "opt", 
		                plots=FALSE)
}
}
\author{
Dhairya Jain
}
