% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{organizations}
\alias{organizations}
\title{Returns data on an animal welfare organization, or organizations, based on specified criteria.}
\usage{
organizations(
  organization_id = NULL,
  name = NULL,
  location = NULL,
  distance = NULL,
  state = NULL,
  country = NULL,
  query = NULL,
  sort = NULL,
  results_per_page = 20,
  pages = 1,
  return_df = FALSE
)
}
\arguments{
\item{organization_id}{Returns results for specified :code:`organization_id`. Can be a character 
vector or a vector or list of character vectors representing multiple organizations.}

\item{name}{Returns results matching or partially matching organization name.}

\item{location}{Returns results by specified location. Must be in the format 'city, state' 
for city-level results, 'latitude, longitude' for lat-long results, or 'postal code'.}

\item{distance}{Returns results within the distance of the specified location. If not given, 
defaults to 100 miles. Maximum distance range is 500 miles.}

\item{state}{Filters the results by the selected state. Must be a two-letter state code abbreviation of the state 
name, such as 'WA' for Washington or 'NY' for New York.}

\item{country}{Filters results to specified country. Must be a two-letter abbreviation of the country and is limited 
to the United States and Canada.}

\item{query}{Search matching and partially matching name, city or state.}

\item{sort}{Sorts by specified attribute. Leading dashes represents a reverse-order sort. Must be one of 'recent', '-recent', 'distance', or '-distance'.}

\item{results_per_page}{Number of results to return per page. Defaults to 20 results and cannot exceed 100 results per page.}

\item{pages}{Specifies which page of results to return. Defaults to the first page of results. If set to NULL, all results will be returned.}

\item{return_df}{If TRUE, the results will be returned as a data.frame. Currently does not do anything.}
}
\value{
List of returned JSON data of organizations matching given search criteria.
}
\description{
Returns data on an animal welfare organization, or organizations, based on specified criteria.
}
\examples{
\dontrun{
pf <- Petfinder(key=key, secret=secret) # Initialize Petfinder class
pf$organizations(state='WA', results_per_page = 100, pages = 2)
pf$organizations(organization_id=c(orgid1, orgid2, orgid3))
}
}
