% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{summary.pointfore}
\alias{summary.pointfore}
\title{Method for object of class pointfore}
\usage{
\method{summary}{pointfore}(object, ...)
}
\arguments{
\item{object}{An object of class \code{pointfore}}

\item{...}{Other arguments when summary is applied to another class object}
}
\value{
It returns a list with the parameter estimates and their standard deviations,
t-stat and p-values. It also returns the J-test and p-value for the null hypothesis that
the forecast is generated by the postulated functional with an information set that contains
the instruments.
}
\description{
It presents results from the \code{\link{estimate.functional}} estimation as summary does
for the \code{lm} or \code{gmm} class objects for example.
It also computes the test of overidentifying restrictions.
}
\examples{
# estimate.functional generates a pointfore object...
res <- estimate.functional(Y=GDP$observation, X=GDP$forecast,
model=constant,
instruments="const")

# ...which can be summarized with the \\code{summary} function.
summary(res)
}
