% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk_postcode_lookup.R
\name{bulk_postcode_lookup}
\alias{bulk_postcode_lookup}
\title{Bulk postcode lookup}
\usage{
bulk_postcode_lookup(postcodes)
}
\arguments{
\item{postcodes}{Accepts a list of postcodes. Accepts up to 100 postcodes.
For only one postcode use \code{\link{postcode_lookup}}.}
}
\value{
A list of length one.
}
\description{
Returns a list of matching postcodes and respective available data.
}
\examples{
\donttest{
pc_list <- list(
postcodes = c("PR3 0SG", "M45 6GN", "EX165BL")) # spaces are ignored
bulk_postcode_lookup(pc_list)
# The function needs a list of length one. This won't work:
bulk_postcode_lookup(list("PR3 0SG", "M45 6GN", "EX165BL"))
}

}
\seealso{
\code{\link{postcode_lookup}} for documentation.
}
