% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_outcode.R
\name{nearest_outcode}
\alias{nearest_outcode}
\title{Nearest outcode}
\usage{
nearest_outcode(outcode, limit = 10, radius = 5000)
}
\arguments{
\item{outcode}{A string with a UK postcode.}

\item{limit}{An integer. Optional parameter. Limits number of postcodes matches to return.
Defaults to 10. Needs to be less than 100.}

\item{radius}{An integer. Optional parameter. Limits number of postcodes matches to return.
Defaults to 5,000m. Needs to be less than 25,000m.}
}
\value{
A list of geographical properties.
}
\description{
Returns nearest outcodes for a given outcode.
The search is based on the relative distance of the outcode centroid.
}
\examples{
\donttest{
nearest_outcode("EC1Y")
nearest_outcode("EC1Y", limit = 11)
nearest_outcode("EC1Y", limit = 11, radius = 6000)
}

}
\seealso{
\code{\link{postcode_lookup}} for documentation.
}
