% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_group_var.R
\name{filter_by_group_var}
\alias{filter_by_group_var}
\title{Filter by Group Variable}
\usage{
filter_by_group_var(df, grp_var, grp_1, grp_2, vars)
}
\arguments{
\item{df}{A data frame which must have a column to identify two different groups.}

\item{grp_var}{The column with the two groups, e.g., 'Treatment'.}

\item{grp_1}{The first group identifier in the \code{grp_var} column, e.g., 'control'.}

\item{grp_2}{The second group identifier in the \code{grp_var} column, e.g., 'drug_a'.}

\item{vars}{The column variables the researcher is interested in. The researcher can subset the columns instead of using all potential column variables.}
}
\value{
A list of two data frames that are subsets of the original
data frame, separated by their group status.
}
\description{
This function takes a data frame with two groups and splits them by a group identifier and specified column variables.
}
\details{
This function checks if the input data frame, group variable,
and column variables are valid. It ensures that the specified groups exist
within the group variable column. The function then filters the data for each
group and returns a list containing the filtered data frames.
}
\examples{
# Load example data
data("group_data_example")

# Use the function to filter by group
result <- filter_by_group_var(df=group_data_example, grp_var="group",
grp_1 ='placebo',grp_2 ='drug',vars=c("v1", "v2"))
print(result$group_1)
print(result$group_2)

}
