% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_p0_score_ci.R
\name{solve_p0_score_ci}
\alias{solve_p0_score_ci}
\title{Calculate the Adjusted Proportion Estimate and Confidence Interval}
\usage{
solve_p0_score_ci(p_hat, n, z = 1.96)
}
\arguments{
\item{p_hat}{Numeric value. The proportion estimate. Must be between 0 and 1.}

\item{n}{Numeric value. The sample size. Must be a positive integer.}

\item{z}{Numeric value. The z-score for the desired confidence level. Default is 1.96 (approximately 95\% confidence interval).}
}
\value{
A list with two elements:
\item{p0}{The adjusted proportion estimate.}
\item{confidence_interval}{A numeric vector of length 2 containing the lower and upper bounds of the confidence interval.}
}
\description{
This function calculates the adjusted proportion estimate (p0) and the confidence interval for a given proportion estimate (p_hat) and sample size (n) using the score method.
}
\examples{
solve_p0_score_ci(p_hat = 9/10, n = 10)

}
