% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lasso_multi}
\alias{lasso_multi}
\title{Lasso logistic regression for multinomial response variable with fixed step}
\usage{
lasso_multi(data,y,x,lambda,max_step=10000,image=FALSE,fista=TRUE)
}
\arguments{
\item{data}{name of the dataset}

\item{y}{name of the dependent variables}

\item{x}{name of the independent variable}

\item{lambda}{a number or a vector of lambda-value to be evaluated in the regression}

\item{max_step}{maximum number of steps}

\item{image}{plots the evolution of errors in term of lambda values}

\item{fista}{fista=TRUE: use FISTA algortihm for the multiclass logistic regression; fista=FALSE: use ISTA algortihm}
}
\value{
A list containing:
\itemize{
  \item{\code{coefficients}: A matrix where each column represents the estimated regression coefficients for a different lambda value.}
  \item{\code{error_evolution}: A numeric vector tracking the error at certain step.}
  \item{\code{num_steps}: An integer vector indicating the number of steps in which errors are calculated.}
}
}
\description{
the function realizes L1-regularized classification for multinomial response variable using ISTA / FISTA algorithm
}
\details{
lasso_multi
}
\examples{
library(glmnet)
data("MultinomialExample")
x<-MultinomialExample$x
y<-MultinomialExample$y
mult<-as.data.frame(cbind(x,y))
lasso_multi(mult,y="y",x=colnames(mult)[-31],max_step = 1000,lambda=0.01,image=TRUE,fista=TRUE)
}
