% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertTime.R
\name{ConvertTime}
\alias{ConvertTime}
\title{Extract and Convert Time Data to Decimal Hours}
\usage{
ConvertTime(raw)
}
\arguments{
\item{raw}{Output from MARS.}
}
\value{
A data frame containing the time information in decimal hours.
}
\description{
The function extracts and converts run time information from MARS output.
}
\examples{
# Example with "hours and minutes" format
raw_data <- data.frame(
  V1 = c("Header", "Row1", "Row2"),
  V2 = c("Time", "1 h 30 min", "2 h 45 min")
)
plate_time <- ConvertTime(raw_data)
print(plate_time)

# Example with decimal hours format
raw_data2 <- data.frame(
  V1 = c("Header", "Row1", "Row2"),
  V2 = c("Time", "1.5", "2.75")
)
plate_time2 <- ConvertTime(raw_data2)
print(plate_time2)

}
