% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_search.R
\name{module_search}
\alias{module_search}
\alias{search_ui}
\alias{search_server}
\title{Search Module}
\usage{
search_ui(id, label = "Search...", multiple = FALSE, random = FALSE)

search_server(id, choices, start_random = FALSE)
}
\arguments{
\item{id}{A unique identifier for the module.}

\item{label}{The label text for the select input.}

\item{multiple}{Whether to allow multiple selections (default: FALSE).}

\item{random}{Whether to show a randomize button (default: FALSE).}

\item{choices}{A reactive expression that returns a vector of choices for the select input.}

\item{start_random}{Whether to select a random value when choices are updated.}
}
\value{
A Shiny UI object.

A reactive expression containing the selected value(s).
}
\description{
Search Module
}
\details{
This module provides a reusable search component with a select input and optional randomize
button. It can be used to create searchable drop-downs with support for multiple selection and
random choice selection. The module handles updating choices dynamically and provides a reactive
value for the selected item(s).
}
\section{Functions}{
\itemize{
\item \code{search_ui()}: UI function for the search module.

\item \code{search_server()}: Server function for the search module.

}}
