% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nawru.R
\name{is.NAWRUmodel}
\alias{is.NAWRUmodel}
\title{\code{NAWRUodel} object check}
\usage{
is.NAWRUmodel(object, return.logical = FALSE)
}
\arguments{
\item{object}{An object to be tested.}

\item{return.logical}{If \code{return.logical = FALSE} (default), an error message is printed
if the object is not of class \code{NAWRUmodel}. If \code{return.logical = TRUE}, a logical
value is returned.}
}
\value{
A logical value or nothing, depending on the value of \code{return.logical}.
}
\description{
Tests whether the input object is a valid object of class \code{NAWRUmodel}.
}
\examples{
# load data for France
data("gap")
tsList <- amecoData2input(gap$France, alpha = 0.65)

# Traditional phillips curve
model <- NAWRUmodel(tsl = tsList, trend = "RW2", cycle = "AR2", type = "NKP", cycleLag = 0:1)
is.NAWRUmodel(model, return.logical = TRUE)
attr(model, "phillips curve")$cycleLag <- 0
is.NAWRUmodel(model, return.logical = TRUE)
}
