% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RHRVEasy.R
\name{RHRVEasyStats}
\alias{RHRVEasyStats}
\title{Rerun the statistical analysis from a previous `RHRVEasy()` call}
\usage{
RHRVEasyStats(
  RHRVEasyResultObject,
  correctionMethod = c("bonferroni", "holm", "hochberg", "hommel", "BH", "BY", "fdr",
    "none"),
  significance = 0.05
)
}
\arguments{
\item{RHRVEasyResultObject}{An object of class `RHRVEasyResult` as returned
by `RHRVEasy()`}

\item{correctionMethod}{The method to correct for multiple comparisons. Can
be one of "bonferroni", "holm", "hochberg", "hommel", "BH", "BY", "fdr" and
"none". Default is "bonferroni".}

\item{significance}{The significance level to use in the statistical
analysis. By default, it is set to 0.05.}
}
\value{
An object of class `RHRVEasyResult` containing the HRV indices
(slot `$HRVIndices`) and the statistical analysis results (slot `$stats`)
}
\description{
Rerun the statistical analysis from a previous `RHRVEasy()` call
}
\seealso{
[RHRVEasy()]
}
