% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_net.R
\name{stabilitySelection}
\alias{stabilitySelection}
\title{Selection of the regularization parameter by StARS (Liu et al., 2010).}
\usage{
stabilitySelection(counts, lambdas = NULL, B = 20)
}
\arguments{
\item{counts}{a n x p matrix of RNA-seq expression (numeric matrix or data
frame)}

\item{lambdas}{a sequence of decreasing positive numbers to control the
regularization (numeric vector). Default to \code{NULL}}

\item{B}{number of iterations for stability selection. Default to 20}
}
\value{
S3 object of class \code{stabilitySelection} : a list consisting of
  \item{\code{lambdas}}{ numeric regularization parameters used for
  regularization path}
  \item{\code{B}}{ number of iterations for stability selection}
  \item{\code{best}}{ index of the regularization parameter selected by StARS
  in \code{lambdas}}
  \item{\code{variabilities}}{ numeric vector having same length than lambdas
  and providing the variability value as defined by StARS along the path}
}
\description{
\code{stabilitySelection} implements the regularization parameter selection
of (Liu et al., 2010) called 'Stability Approach to Regularization Selection'
(StARS).
}
\details{
When input \code{lambdas} are null the default sequence of
\code{\link[glmnet]{glmnet}} (see \code{\link{GLMnetwork}} for details).
}
\examples{
data(lung)
lambdas <- 4 * 10^(seq(0, -2, length = 5))
stability_lung <- stabilitySelection(lung, lambdas = lambdas, B = 4)
\dontrun{plot(stability_lung)}

}
\references{
{Liu, H., Roeber, K. and Wasserman, L. (2010) Stability approach
to regularization selection (StARS) for high dimensional graphical models. In
\emph{Proceedings of Neural Information Processing Systems (NIPS 2010)},
\strong{23}, 1432-1440, Vancouver, Canada.}
}
\seealso{
\code{\link{GLMnetwork}}
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@gmail.com}
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
