% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{make_dds}
\alias{make_dds}
\title{Make DESeqDataSet from counts matrix and metadata}
\usage{
make_dds(counts, metadata, ah_record, design = ~1)
}
\arguments{
\item{counts}{The genes x samples counts matrix with row names. At least one row name must be an ENSEMBL gene ID,
since gene annotation is done via the ENSEMBL database.}

\item{metadata}{data.frame of sample information. Order of rows corresponds to the order of columns in the counts matrix.}

\item{ah_record}{ID of AnnotationHub record used to retrieve an \code{EnsDb} object.}

\item{design}{The design formula specified in \code{DESeqDataSet()}
To view all valid record IDs, run

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(AnnotationHub)
mcols(AnnotationHub()) \%>\%
 as_tibble(rownames="ah_record") \%>\%
 filter(rdataclass=="EnsDb")
}\if{html}{\out{</div>}}}
}
\value{
A \code{DESeq2::DESeqDataSet} object containing the counts matrix and metadata.
}
\description{
Make DESeqDataSet from counts matrix and metadata
}
\examples{
\donttest{
library("DESeq2")
count_mat <- counts(T47D)
meta <- data.frame(colData(T47D))
dds <- make_dds(counts = count_mat, metadata = meta, ah_record = "AH89426")
}

}
